/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.DefaultRetryStrategy;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.aliyun.openservices.tablestore.hadoop.Credential;
import com.aliyun.openservices.tablestore.hadoop.Endpoint;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public class TableStore {
    public static final String ENDPOINT = "TABLESTORE_ENDPOINT";
    public static final String CREDENTIAL = "TABLESTORE_CREDENTIAL";

    public static void setCredential(JobContext job, String accessKeyId, String accessKeySecret) {
        Preconditions.checkNotNull((Object)job, (Object)"job must be nonnull");
        TableStore.setCredential(job.getConfiguration(), new Credential(accessKeyId, accessKeySecret, null));
    }

    public static void setCredential(JobContext job, String accessKeyId, String accessKeySecret, String securityToken) {
        Preconditions.checkNotNull((Object)job, (Object)"job must be nonnull");
        TableStore.setCredential(job.getConfiguration(), new Credential(accessKeyId, accessKeySecret, securityToken));
    }

    public static void setCredential(Configuration conf, Credential cred) {
        Preconditions.checkNotNull((Object)conf, (Object)"conf must be nonnull");
        Preconditions.checkNotNull((Object)cred, (Object)"cred must be nonnull");
        conf.set(CREDENTIAL, cred.serialize());
    }

    public static void setEndpoint(JobContext job, String endpoint) {
        Preconditions.checkNotNull((Object)job, (Object)"job must be nonnull");
        TableStore.setEndpoint(job.getConfiguration(), new Endpoint(endpoint));
    }

    public static void setEndpoint(JobContext job, String endpoint, String instance) {
        Preconditions.checkNotNull((Object)job, (Object)"job must be nonnull");
        TableStore.setEndpoint(job.getConfiguration(), new Endpoint(endpoint, instance));
    }

    public static void setEndpoint(Configuration conf, Endpoint ep) {
        Preconditions.checkNotNull((Object)conf, (Object)"conf must be nonnull");
        Preconditions.checkNotNull((Object)ep, (Object)"ep must be nonnull");
        conf.set(ENDPOINT, ep.serialize());
    }

    public static SyncClientInterface newOtsClient(Configuration conf) {
        Credential cred = Credential.deserialize(conf.get(CREDENTIAL));
        Endpoint ep = Endpoint.deserialize(conf.get(ENDPOINT));
        ClientConfiguration clientCfg = new ClientConfiguration();
        clientCfg.setRetryStrategy((RetryStrategy)new DefaultRetryStrategy(10L, TimeUnit.SECONDS));
        if (cred.securityToken == null) {
            return new SyncClient(ep.endpoint, cred.accessKeyId, cred.accessKeySecret, ep.instance, clientCfg);
        }
        return new SyncClient(ep.endpoint, cred.accessKeyId, cred.accessKeySecret, ep.instance, clientCfg, cred.securityToken);
    }
}

