/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Pair;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.aliyun.openservices.tablestore.hadoop.ColumnWritable;
import com.aliyun.openservices.tablestore.hadoop.ConditionWritable;
import com.aliyun.openservices.tablestore.hadoop.PrimaryKeyWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.hadoop.io.Writable;

public class RowUpdateChangeWritable
implements Writable,
Externalizable {
    private RowUpdateChange updateRow;

    public RowUpdateChangeWritable() {
    }

    public RowUpdateChangeWritable(RowUpdateChange updateRow) {
        Preconditions.checkNotNull((Object)updateRow, (Object)"updateRow must be nonnull.");
        this.updateRow = updateRow;
    }

    public RowUpdateChange getRowUpdateChange() {
        return this.updateRow;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.updateRow.getTableName());
        new PrimaryKeyWritable(this.updateRow.getPrimaryKey()).write(out);
        new ConditionWritable(this.updateRow.getCondition()).write(out);
        List cols = this.updateRow.getColumnsToUpdate();
        out.writeInt(cols.size());
        for (Pair pair : cols) {
            Column col = (Column)pair.getFirst();
            switch ((RowUpdateChange.Type)pair.getSecond()) {
                case PUT: {
                    out.writeByte(95);
                    new ColumnWritable(col).write(out);
                    break;
                }
                case DELETE: {
                    out.writeByte(96);
                    out.writeUTF(col.getName());
                    out.writeLong(col.getTimestamp());
                    break;
                }
                case DELETE_ALL: {
                    out.writeByte(99);
                    out.writeUTF(col.getName());
                }
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        String tableName = in.readUTF();
        PrimaryKey pkey = PrimaryKeyWritable.read(in).getPrimaryKey();
        RowUpdateChange updateRow = new RowUpdateChange(tableName, pkey);
        updateRow.setCondition(ConditionWritable.read(in).getCondition());
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            String colName;
            byte tagCol = in.readByte();
            if (tagCol == 95) {
                updateRow.put(ColumnWritable.read(in).getColumn());
                continue;
            }
            if (tagCol == 96) {
                colName = in.readUTF();
                long ts = in.readLong();
                updateRow.deleteColumn(colName, ts);
                continue;
            }
            if (tagCol == 99) {
                colName = in.readUTF();
                updateRow.deleteColumns(colName);
                continue;
            }
            throw new IOException("broken input stream");
        }
        this.updateRow = updateRow;
    }

    public static RowUpdateChangeWritable read(DataInput in) throws IOException {
        RowUpdateChangeWritable w = new RowUpdateChangeWritable();
        w.readFields(in);
        return w;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readFields(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }
}

