/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.aliyun.openservices.tablestore.hadoop.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.Writable;

public class Endpoint
implements Writable {
    public String endpoint;
    public String instance;
    private final Pattern kInstPattern = Pattern.compile("(http|https)://(.*?)[.].+");

    public Endpoint() {
    }

    public Endpoint(String endpoint) {
        this(endpoint, null);
    }

    public Endpoint(String endpoint, String instance) {
        Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint should not be null.");
        this.endpoint = endpoint;
        if (instance != null) {
            this.instance = instance;
        } else {
            Matcher m = this.kInstPattern.matcher(endpoint);
            Preconditions.checkArgument((boolean)m.matches(), (Object)("cannot parse instance from endpoint: " + endpoint));
            Preconditions.checkArgument((m.groupCount() == 2 ? 1 : 0) != 0, (Object)("cannot parse instance from endpoint: " + endpoint));
            this.instance = m.group(2);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint a = (Endpoint)obj;
        if (!this.endpoint.equals(a.endpoint)) {
            return false;
        }
        return this.instance.equals(a.instance);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(57);
        out.writeUTF(this.endpoint);
        out.writeUTF(this.instance);
    }

    public void readFields(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag != 57) {
            throw new IOException("broken input stream");
        }
        this.endpoint = null;
        this.instance = null;
        this.endpoint = in.readUTF();
        this.instance = in.readUTF();
    }

    public static Endpoint read(DataInput in) throws IOException {
        Endpoint w = new Endpoint();
        w.readFields(in);
        return w;
    }

    public String serialize() {
        return Utils.serialize(this);
    }

    public static Endpoint deserialize(String in) {
        if (in == null) {
            return null;
        }
        byte[] buf = Base64.decodeBase64((String)in);
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        DataInputStream din = new DataInputStream(is);
        try {
            return Endpoint.read(din);
        }
        catch (IOException ex) {
            return null;
        }
    }
}

