/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.aliyun.openservices.tablestore.hadoop.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.Writable;

public class Credential
implements Writable {
    public String accessKeyId;
    public String accessKeySecret;
    public String securityToken;

    public Credential() {
    }

    public Credential(String accessKeyId, String accessKeySecret, String securityToken) {
        Preconditions.checkNotNull((Object)accessKeyId, (Object)"accessKeyId should not be null.");
        Preconditions.checkNotNull((Object)accessKeySecret, (Object)"accessKeySecret should not be null.");
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Credential)) {
            return false;
        }
        Credential a = (Credential)obj;
        if (!this.accessKeyId.equals(a.accessKeyId)) {
            return false;
        }
        if (!this.accessKeySecret.equals(a.accessKeySecret)) {
            return false;
        }
        if (this.securityToken == null) {
            return a.securityToken == null;
        }
        return this.securityToken.equals(a.securityToken);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(53);
        out.writeUTF(this.accessKeyId);
        out.writeUTF(this.accessKeySecret);
        if (this.securityToken != null) {
            out.writeByte(54);
            out.writeUTF(this.securityToken);
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag != 53) {
            throw new IOException("broken input stream");
        }
        this.accessKeyId = null;
        this.accessKeySecret = null;
        this.securityToken = null;
        this.accessKeyId = in.readUTF();
        this.accessKeySecret = in.readUTF();
        byte tagSecurityToken = this.nextTag(in);
        if (tagSecurityToken == 54) {
            this.securityToken = in.readUTF();
        }
    }

    public static Credential read(DataInput in) throws IOException {
        Credential w = new Credential();
        w.readFields(in);
        return w;
    }

    private byte nextTag(DataInput in) throws IOException {
        try {
            return in.readByte();
        }
        catch (EOFException ex) {
            return 0;
        }
    }

    public String serialize() {
        return Utils.serialize(this);
    }

    public static Credential deserialize(String in) {
        if (in == null) {
            return null;
        }
        byte[] buf = Base64.decodeBase64((String)in);
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        DataInputStream din = new DataInputStream(is);
        try {
            return Credential.read(din);
        }
        catch (IOException ex) {
            return null;
        }
    }
}

