/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class ReEncryptRequest
extends Request {
    @Query
    @NameInMap(value="CiphertextBlob")
    @Validation(required=true)
    private String ciphertextBlob;
    @Query
    @NameInMap(value="DestinationEncryptionContext")
    private Map<String, ?> destinationEncryptionContext;
    @Query
    @NameInMap(value="DestinationKeyId")
    @Validation(required=true)
    private String destinationKeyId;
    @Query
    @NameInMap(value="SourceEncryptionAlgorithm")
    private String sourceEncryptionAlgorithm;
    @Query
    @NameInMap(value="SourceEncryptionContext")
    private Map<String, ?> sourceEncryptionContext;
    @Query
    @NameInMap(value="SourceKeyId")
    private String sourceKeyId;
    @Query
    @NameInMap(value="SourceKeyVersionId")
    private String sourceKeyVersionId;

    private ReEncryptRequest(Builder builder) {
        super((Request.Builder)builder);
        this.ciphertextBlob = builder.ciphertextBlob;
        this.destinationEncryptionContext = builder.destinationEncryptionContext;
        this.destinationKeyId = builder.destinationKeyId;
        this.sourceEncryptionAlgorithm = builder.sourceEncryptionAlgorithm;
        this.sourceEncryptionContext = builder.sourceEncryptionContext;
        this.sourceKeyId = builder.sourceKeyId;
        this.sourceKeyVersionId = builder.sourceKeyVersionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReEncryptRequest create() {
        return ReEncryptRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCiphertextBlob() {
        return this.ciphertextBlob;
    }

    public Map<String, ?> getDestinationEncryptionContext() {
        return this.destinationEncryptionContext;
    }

    public String getDestinationKeyId() {
        return this.destinationKeyId;
    }

    public String getSourceEncryptionAlgorithm() {
        return this.sourceEncryptionAlgorithm;
    }

    public Map<String, ?> getSourceEncryptionContext() {
        return this.sourceEncryptionContext;
    }

    public String getSourceKeyId() {
        return this.sourceKeyId;
    }

    public String getSourceKeyVersionId() {
        return this.sourceKeyVersionId;
    }

    public static final class Builder
    extends Request.Builder<ReEncryptRequest, Builder> {
        private String ciphertextBlob;
        private Map<String, ?> destinationEncryptionContext;
        private String destinationKeyId;
        private String sourceEncryptionAlgorithm;
        private Map<String, ?> sourceEncryptionContext;
        private String sourceKeyId;
        private String sourceKeyVersionId;

        private Builder() {
        }

        private Builder(ReEncryptRequest request) {
            super((Request)request);
            this.ciphertextBlob = request.ciphertextBlob;
            this.destinationEncryptionContext = request.destinationEncryptionContext;
            this.destinationKeyId = request.destinationKeyId;
            this.sourceEncryptionAlgorithm = request.sourceEncryptionAlgorithm;
            this.sourceEncryptionContext = request.sourceEncryptionContext;
            this.sourceKeyId = request.sourceKeyId;
            this.sourceKeyVersionId = request.sourceKeyVersionId;
        }

        public Builder ciphertextBlob(String ciphertextBlob) {
            this.putQueryParameter("CiphertextBlob", ciphertextBlob);
            this.ciphertextBlob = ciphertextBlob;
            return this;
        }

        public Builder destinationEncryptionContext(Map<String, ?> destinationEncryptionContext) {
            String destinationEncryptionContextShrink = this.shrink(destinationEncryptionContext, "DestinationEncryptionContext", "json");
            this.putQueryParameter("DestinationEncryptionContext", destinationEncryptionContextShrink);
            this.destinationEncryptionContext = destinationEncryptionContext;
            return this;
        }

        public Builder destinationKeyId(String destinationKeyId) {
            this.putQueryParameter("DestinationKeyId", destinationKeyId);
            this.destinationKeyId = destinationKeyId;
            return this;
        }

        public Builder sourceEncryptionAlgorithm(String sourceEncryptionAlgorithm) {
            this.putQueryParameter("SourceEncryptionAlgorithm", sourceEncryptionAlgorithm);
            this.sourceEncryptionAlgorithm = sourceEncryptionAlgorithm;
            return this;
        }

        public Builder sourceEncryptionContext(Map<String, ?> sourceEncryptionContext) {
            String sourceEncryptionContextShrink = this.shrink(sourceEncryptionContext, "SourceEncryptionContext", "json");
            this.putQueryParameter("SourceEncryptionContext", sourceEncryptionContextShrink);
            this.sourceEncryptionContext = sourceEncryptionContext;
            return this;
        }

        public Builder sourceKeyId(String sourceKeyId) {
            this.putQueryParameter("SourceKeyId", sourceKeyId);
            this.sourceKeyId = sourceKeyId;
            return this;
        }

        public Builder sourceKeyVersionId(String sourceKeyVersionId) {
            this.putQueryParameter("SourceKeyVersionId", sourceKeyVersionId);
            this.sourceKeyVersionId = sourceKeyVersionId;
            return this;
        }

        public ReEncryptRequest build() {
            return new ReEncryptRequest(this);
        }
    }
}

