/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListSecretsRequest
extends Request {
    @Query
    @NameInMap(value="FetchTags")
    private String fetchTags;
    @Query
    @NameInMap(value="Filters")
    private String filters;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer pageSize;

    private ListSecretsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.fetchTags = builder.fetchTags;
        this.filters = builder.filters;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListSecretsRequest create() {
        return ListSecretsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getFetchTags() {
        return this.fetchTags;
    }

    public String getFilters() {
        return this.filters;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<ListSecretsRequest, Builder> {
        private String fetchTags;
        private String filters;
        private Integer pageNumber;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(ListSecretsRequest request) {
            super((Request)request);
            this.fetchTags = request.fetchTags;
            this.filters = request.filters;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
        }

        public Builder fetchTags(String fetchTags) {
            this.putQueryParameter("FetchTags", fetchTags);
            this.fetchTags = fetchTags;
            return this;
        }

        public Builder filters(String filters) {
            this.putQueryParameter("Filters", filters);
            this.filters = filters;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public ListSecretsRequest build() {
            return new ListSecretsRequest(this);
        }
    }
}

