/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class GenerateDataKeyRequest
extends Request {
    @Query
    @NameInMap(value="EncryptionContext")
    private Map<String, ?> encryptionContext;
    @Query
    @NameInMap(value="KeyId")
    @Validation(required=true)
    private String keyId;
    @Query
    @NameInMap(value="KeySpec")
    private String keySpec;
    @Query
    @NameInMap(value="NumberOfBytes")
    @Validation(maximum=1024.0)
    private Integer numberOfBytes;

    private GenerateDataKeyRequest(Builder builder) {
        super((Request.Builder)builder);
        this.encryptionContext = builder.encryptionContext;
        this.keyId = builder.keyId;
        this.keySpec = builder.keySpec;
        this.numberOfBytes = builder.numberOfBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GenerateDataKeyRequest create() {
        return GenerateDataKeyRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Map<String, ?> getEncryptionContext() {
        return this.encryptionContext;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeySpec() {
        return this.keySpec;
    }

    public Integer getNumberOfBytes() {
        return this.numberOfBytes;
    }

    public static final class Builder
    extends Request.Builder<GenerateDataKeyRequest, Builder> {
        private Map<String, ?> encryptionContext;
        private String keyId;
        private String keySpec;
        private Integer numberOfBytes;

        private Builder() {
        }

        private Builder(GenerateDataKeyRequest request) {
            super((Request)request);
            this.encryptionContext = request.encryptionContext;
            this.keyId = request.keyId;
            this.keySpec = request.keySpec;
            this.numberOfBytes = request.numberOfBytes;
        }

        public Builder encryptionContext(Map<String, ?> encryptionContext) {
            String encryptionContextShrink = this.shrink(encryptionContext, "EncryptionContext", "json");
            this.putQueryParameter("EncryptionContext", encryptionContextShrink);
            this.encryptionContext = encryptionContext;
            return this;
        }

        public Builder keyId(String keyId) {
            this.putQueryParameter("KeyId", keyId);
            this.keyId = keyId;
            return this;
        }

        public Builder keySpec(String keySpec) {
            this.putQueryParameter("KeySpec", keySpec);
            this.keySpec = keySpec;
            return this;
        }

        public Builder numberOfBytes(Integer numberOfBytes) {
            this.putQueryParameter("NumberOfBytes", numberOfBytes);
            this.numberOfBytes = numberOfBytes;
            return this;
        }

        public GenerateDataKeyRequest build() {
            return new GenerateDataKeyRequest(this);
        }
    }
}

