/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class GenerateAndExportDataKeyRequest
extends Request {
    @Query
    @NameInMap(value="EncryptionContext")
    private Map<String, ?> encryptionContext;
    @Query
    @NameInMap(value="KeyId")
    @Validation(required=true)
    private String keyId;
    @Query
    @NameInMap(value="KeySpec")
    private String keySpec;
    @Query
    @NameInMap(value="NumberOfBytes")
    @Validation(maximum=1024.0)
    private Integer numberOfBytes;
    @Query
    @NameInMap(value="PublicKeyBlob")
    @Validation(required=true)
    private String publicKeyBlob;
    @Query
    @NameInMap(value="WrappingAlgorithm")
    @Validation(required=true)
    private String wrappingAlgorithm;
    @Query
    @NameInMap(value="WrappingKeySpec")
    @Validation(required=true)
    private String wrappingKeySpec;

    private GenerateAndExportDataKeyRequest(Builder builder) {
        super((Request.Builder)builder);
        this.encryptionContext = builder.encryptionContext;
        this.keyId = builder.keyId;
        this.keySpec = builder.keySpec;
        this.numberOfBytes = builder.numberOfBytes;
        this.publicKeyBlob = builder.publicKeyBlob;
        this.wrappingAlgorithm = builder.wrappingAlgorithm;
        this.wrappingKeySpec = builder.wrappingKeySpec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GenerateAndExportDataKeyRequest create() {
        return GenerateAndExportDataKeyRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Map<String, ?> getEncryptionContext() {
        return this.encryptionContext;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeySpec() {
        return this.keySpec;
    }

    public Integer getNumberOfBytes() {
        return this.numberOfBytes;
    }

    public String getPublicKeyBlob() {
        return this.publicKeyBlob;
    }

    public String getWrappingAlgorithm() {
        return this.wrappingAlgorithm;
    }

    public String getWrappingKeySpec() {
        return this.wrappingKeySpec;
    }

    public static final class Builder
    extends Request.Builder<GenerateAndExportDataKeyRequest, Builder> {
        private Map<String, ?> encryptionContext;
        private String keyId;
        private String keySpec;
        private Integer numberOfBytes;
        private String publicKeyBlob;
        private String wrappingAlgorithm;
        private String wrappingKeySpec;

        private Builder() {
        }

        private Builder(GenerateAndExportDataKeyRequest request) {
            super((Request)request);
            this.encryptionContext = request.encryptionContext;
            this.keyId = request.keyId;
            this.keySpec = request.keySpec;
            this.numberOfBytes = request.numberOfBytes;
            this.publicKeyBlob = request.publicKeyBlob;
            this.wrappingAlgorithm = request.wrappingAlgorithm;
            this.wrappingKeySpec = request.wrappingKeySpec;
        }

        public Builder encryptionContext(Map<String, ?> encryptionContext) {
            String encryptionContextShrink = this.shrink(encryptionContext, "EncryptionContext", "json");
            this.putQueryParameter("EncryptionContext", encryptionContextShrink);
            this.encryptionContext = encryptionContext;
            return this;
        }

        public Builder keyId(String keyId) {
            this.putQueryParameter("KeyId", keyId);
            this.keyId = keyId;
            return this;
        }

        public Builder keySpec(String keySpec) {
            this.putQueryParameter("KeySpec", keySpec);
            this.keySpec = keySpec;
            return this;
        }

        public Builder numberOfBytes(Integer numberOfBytes) {
            this.putQueryParameter("NumberOfBytes", numberOfBytes);
            this.numberOfBytes = numberOfBytes;
            return this;
        }

        public Builder publicKeyBlob(String publicKeyBlob) {
            this.putQueryParameter("PublicKeyBlob", publicKeyBlob);
            this.publicKeyBlob = publicKeyBlob;
            return this;
        }

        public Builder wrappingAlgorithm(String wrappingAlgorithm) {
            this.putQueryParameter("WrappingAlgorithm", wrappingAlgorithm);
            this.wrappingAlgorithm = wrappingAlgorithm;
            return this;
        }

        public Builder wrappingKeySpec(String wrappingKeySpec) {
            this.putQueryParameter("WrappingKeySpec", wrappingKeySpec);
            this.wrappingKeySpec = wrappingKeySpec;
            return this;
        }

        public GenerateAndExportDataKeyRequest build() {
            return new GenerateAndExportDataKeyRequest(this);
        }
    }
}

