/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class EncryptRequest
extends Request {
    @Query
    @NameInMap(value="EncryptionContext")
    private Map<String, ?> encryptionContext;
    @Query
    @NameInMap(value="KeyId")
    @Validation(required=true)
    private String keyId;
    @Query
    @NameInMap(value="Plaintext")
    @Validation(required=true)
    private String plaintext;

    private EncryptRequest(Builder builder) {
        super((Request.Builder)builder);
        this.encryptionContext = builder.encryptionContext;
        this.keyId = builder.keyId;
        this.plaintext = builder.plaintext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static EncryptRequest create() {
        return EncryptRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Map<String, ?> getEncryptionContext() {
        return this.encryptionContext;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getPlaintext() {
        return this.plaintext;
    }

    public static final class Builder
    extends Request.Builder<EncryptRequest, Builder> {
        private Map<String, ?> encryptionContext;
        private String keyId;
        private String plaintext;

        private Builder() {
        }

        private Builder(EncryptRequest request) {
            super((Request)request);
            this.encryptionContext = request.encryptionContext;
            this.keyId = request.keyId;
            this.plaintext = request.plaintext;
        }

        public Builder encryptionContext(Map<String, ?> encryptionContext) {
            String encryptionContextShrink = this.shrink(encryptionContext, "EncryptionContext", "json");
            this.putQueryParameter("EncryptionContext", encryptionContextShrink);
            this.encryptionContext = encryptionContext;
            return this;
        }

        public Builder keyId(String keyId) {
            this.putQueryParameter("KeyId", keyId);
            this.keyId = keyId;
            return this;
        }

        public Builder plaintext(String plaintext) {
            this.putQueryParameter("Plaintext", plaintext);
            this.plaintext = plaintext;
            return this;
        }

        public EncryptRequest build() {
            return new EncryptRequest(this);
        }
    }
}

