/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateNetworkRuleRequest
extends Request {
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;
    @Query
    @NameInMap(value="SourcePrivateIp")
    private String sourcePrivateIp;
    @Query
    @NameInMap(value="Type")
    @Validation(required=true)
    private String type;

    private CreateNetworkRuleRequest(Builder builder) {
        super((Request.Builder)builder);
        this.description = builder.description;
        this.name = builder.name;
        this.sourcePrivateIp = builder.sourcePrivateIp;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateNetworkRuleRequest create() {
        return CreateNetworkRuleRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getSourcePrivateIp() {
        return this.sourcePrivateIp;
    }

    public String getType() {
        return this.type;
    }

    public static final class Builder
    extends Request.Builder<CreateNetworkRuleRequest, Builder> {
        private String description;
        private String name;
        private String sourcePrivateIp;
        private String type;

        private Builder() {
        }

        private Builder(CreateNetworkRuleRequest request) {
            super((Request)request);
            this.description = request.description;
            this.name = request.name;
            this.sourcePrivateIp = request.sourcePrivateIp;
            this.type = request.type;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder sourcePrivateIp(String sourcePrivateIp) {
            this.putQueryParameter("SourcePrivateIp", sourcePrivateIp);
            this.sourcePrivateIp = sourcePrivateIp;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public CreateNetworkRuleRequest build() {
            return new CreateNetworkRuleRequest(this);
        }
    }
}

