/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CertificatePublicKeyEncryptRequest
extends Request {
    @Query
    @NameInMap(value="Algorithm")
    @Validation(required=true)
    private String algorithm;
    @Query
    @NameInMap(value="CertificateId")
    @Validation(required=true)
    private String certificateId;
    @Query
    @NameInMap(value="Plaintext")
    @Validation(required=true)
    private String plaintext;

    private CertificatePublicKeyEncryptRequest(Builder builder) {
        super((Request.Builder)builder);
        this.algorithm = builder.algorithm;
        this.certificateId = builder.certificateId;
        this.plaintext = builder.plaintext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CertificatePublicKeyEncryptRequest create() {
        return CertificatePublicKeyEncryptRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public String getPlaintext() {
        return this.plaintext;
    }

    public static final class Builder
    extends Request.Builder<CertificatePublicKeyEncryptRequest, Builder> {
        private String algorithm;
        private String certificateId;
        private String plaintext;

        private Builder() {
        }

        private Builder(CertificatePublicKeyEncryptRequest request) {
            super((Request)request);
            this.algorithm = request.algorithm;
            this.certificateId = request.certificateId;
            this.plaintext = request.plaintext;
        }

        public Builder algorithm(String algorithm) {
            this.putQueryParameter("Algorithm", algorithm);
            this.algorithm = algorithm;
            return this;
        }

        public Builder certificateId(String certificateId) {
            this.putQueryParameter("CertificateId", certificateId);
            this.certificateId = certificateId;
            return this;
        }

        public Builder plaintext(String plaintext) {
            this.putQueryParameter("Plaintext", plaintext);
            this.plaintext = plaintext;
            return this;
        }

        public CertificatePublicKeyEncryptRequest build() {
            return new CertificatePublicKeyEncryptRequest(this);
        }
    }
}

