/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListRepositoryGroupsRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Query
    @NameInMap(value="includePersonal")
    private Boolean includePersonal;
    @Query
    @NameInMap(value="orderBy")
    private String orderBy;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="page")
    private Long page;
    @Query
    @NameInMap(value="pageSize")
    private Long pageSize;
    @Query
    @NameInMap(value="parentId")
    @Validation(required=true)
    private Long parentId;
    @Query
    @NameInMap(value="search")
    private String search;
    @Query
    @NameInMap(value="sort")
    private String sort;

    private ListRepositoryGroupsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.includePersonal = builder.includePersonal;
        this.orderBy = builder.orderBy;
        this.organizationId = builder.organizationId;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.parentId = builder.parentId;
        this.search = builder.search;
        this.sort = builder.sort;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListRepositoryGroupsRequest create() {
        return ListRepositoryGroupsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Boolean getIncludePersonal() {
        return this.includePersonal;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Long getPage() {
        return this.page;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public String getSearch() {
        return this.search;
    }

    public String getSort() {
        return this.sort;
    }

    public static final class Builder
    extends Request.Builder<ListRepositoryGroupsRequest, Builder> {
        private String accessToken;
        private Boolean includePersonal;
        private String orderBy;
        private String organizationId;
        private Long page;
        private Long pageSize;
        private Long parentId;
        private String search;
        private String sort;

        private Builder() {
        }

        private Builder(ListRepositoryGroupsRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.includePersonal = request.includePersonal;
            this.orderBy = request.orderBy;
            this.organizationId = request.organizationId;
            this.page = request.page;
            this.pageSize = request.pageSize;
            this.parentId = request.parentId;
            this.search = request.search;
            this.sort = request.sort;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder includePersonal(Boolean includePersonal) {
            this.putQueryParameter("includePersonal", includePersonal);
            this.includePersonal = includePersonal;
            return this;
        }

        public Builder orderBy(String orderBy) {
            this.putQueryParameter("orderBy", orderBy);
            this.orderBy = orderBy;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder page(Long page) {
            this.putQueryParameter("page", page);
            this.page = page;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("pageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder parentId(Long parentId) {
            this.putQueryParameter("parentId", parentId);
            this.parentId = parentId;
            return this;
        }

        public Builder search(String search) {
            this.putQueryParameter("search", search);
            this.search = search;
            return this;
        }

        public Builder sort(String sort) {
            this.putQueryParameter("sort", sort);
            this.sort = sort;
            return this;
        }

        public ListRepositoryGroupsRequest build() {
            return new ListRepositoryGroupsRequest(this);
        }
    }
}

