/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListMergeRequestsRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Query
    @NameInMap(value="authorIds")
    private String authorIds;
    @Query
    @NameInMap(value="filter")
    private String filter;
    @Query
    @NameInMap(value="groupIds")
    private String groupIds;
    @Query
    @NameInMap(value="orderBy")
    private String orderBy;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="page")
    private Long page;
    @Query
    @NameInMap(value="pageSize")
    private Long pageSize;
    @Query
    @NameInMap(value="projectIds")
    private String projectIds;
    @Query
    @NameInMap(value="reviewerIds")
    private String reviewerIds;
    @Query
    @NameInMap(value="search")
    private String search;
    @Query
    @NameInMap(value="sort")
    private String sort;
    @Query
    @NameInMap(value="state")
    private String state;

    private ListMergeRequestsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.authorIds = builder.authorIds;
        this.filter = builder.filter;
        this.groupIds = builder.groupIds;
        this.orderBy = builder.orderBy;
        this.organizationId = builder.organizationId;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.projectIds = builder.projectIds;
        this.reviewerIds = builder.reviewerIds;
        this.search = builder.search;
        this.sort = builder.sort;
        this.state = builder.state;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListMergeRequestsRequest create() {
        return ListMergeRequestsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAuthorIds() {
        return this.authorIds;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getGroupIds() {
        return this.groupIds;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Long getPage() {
        return this.page;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getProjectIds() {
        return this.projectIds;
    }

    public String getReviewerIds() {
        return this.reviewerIds;
    }

    public String getSearch() {
        return this.search;
    }

    public String getSort() {
        return this.sort;
    }

    public String getState() {
        return this.state;
    }

    public static final class Builder
    extends Request.Builder<ListMergeRequestsRequest, Builder> {
        private String accessToken;
        private String authorIds;
        private String filter;
        private String groupIds;
        private String orderBy;
        private String organizationId;
        private Long page;
        private Long pageSize;
        private String projectIds;
        private String reviewerIds;
        private String search;
        private String sort;
        private String state;

        private Builder() {
        }

        private Builder(ListMergeRequestsRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.authorIds = request.authorIds;
            this.filter = request.filter;
            this.groupIds = request.groupIds;
            this.orderBy = request.orderBy;
            this.organizationId = request.organizationId;
            this.page = request.page;
            this.pageSize = request.pageSize;
            this.projectIds = request.projectIds;
            this.reviewerIds = request.reviewerIds;
            this.search = request.search;
            this.sort = request.sort;
            this.state = request.state;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder authorIds(String authorIds) {
            this.putQueryParameter("authorIds", authorIds);
            this.authorIds = authorIds;
            return this;
        }

        public Builder filter(String filter) {
            this.putQueryParameter("filter", filter);
            this.filter = filter;
            return this;
        }

        public Builder groupIds(String groupIds) {
            this.putQueryParameter("groupIds", groupIds);
            this.groupIds = groupIds;
            return this;
        }

        public Builder orderBy(String orderBy) {
            this.putQueryParameter("orderBy", orderBy);
            this.orderBy = orderBy;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder page(Long page) {
            this.putQueryParameter("page", page);
            this.page = page;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("pageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder projectIds(String projectIds) {
            this.putQueryParameter("projectIds", projectIds);
            this.projectIds = projectIds;
            return this;
        }

        public Builder reviewerIds(String reviewerIds) {
            this.putQueryParameter("reviewerIds", reviewerIds);
            this.reviewerIds = reviewerIds;
            return this;
        }

        public Builder search(String search) {
            this.putQueryParameter("search", search);
            this.search = search;
            return this;
        }

        public Builder sort(String sort) {
            this.putQueryParameter("sort", sort);
            this.sort = sort;
            return this;
        }

        public Builder state(String state) {
            this.putQueryParameter("state", state);
            this.state = state;
            return this;
        }

        public ListMergeRequestsRequest build() {
            return new ListMergeRequestsRequest(this);
        }
    }
}

