/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.async;

import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;

public class SofaTracerRunnable
implements Runnable {
    private long tid = Thread.currentThread().getId();
    private Runnable wrappedRunnable;
    private SofaTraceContext traceContext;
    private SofaTracerSpan currentSpan;

    public SofaTracerRunnable(Runnable wrappedRunnable) {
        this.initRunnable(wrappedRunnable, SofaTraceContextHolder.getSofaTraceContext());
    }

    public SofaTracerRunnable(Runnable wrappedRunnable, SofaTraceContext traceContext) {
        this.initRunnable(wrappedRunnable, traceContext);
    }

    private void initRunnable(Runnable wrappedRunnable, SofaTraceContext traceContext) {
        this.wrappedRunnable = wrappedRunnable;
        this.traceContext = traceContext;
        this.currentSpan = !traceContext.isEmpty() ? traceContext.getCurrentSpan() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Thread.currentThread().getId() != this.tid && this.currentSpan != null) {
            this.traceContext.push(this.currentSpan);
        }
        try {
            this.wrappedRunnable.run();
        }
        finally {
            if (Thread.currentThread().getId() != this.tid && this.currentSpan != null) {
                this.traceContext.pop();
            }
        }
    }
}

