/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.profile.enumeration;

import com.alipay.sofa.common.profile.enumeration.Enum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class EnumUtil {
    private static final Map entries = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getUnderlyingClass(Class enumClass) {
        Class var2;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(enumClass.getClassLoader());
            var2 = EnumUtil.getEnumType(enumClass).getUnderlyingClass();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNameDefined(Class enumClass, String name) {
        boolean var3;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(enumClass.getClassLoader());
            var3 = EnumUtil.getEnumType((Class)enumClass).nameMap.containsKey(name);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return var3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValueDefined(Class enumClass, Number value) {
        boolean var3;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(enumClass.getClassLoader());
            var3 = EnumUtil.getEnumType((Class)enumClass).valueMap.containsKey(value);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return var3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enum getEnumByName(Class enumClass, String name) {
        Enum var4;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(enumClass.getClassLoader());
            Enum.EnumType enumType = EnumUtil.getEnumType(enumClass);
            if (enumType.enumList.size() != enumType.nameMap.size()) {
                enumType.populateNames(enumClass);
            }
            var4 = (Enum)enumType.nameMap.get(name);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enum getEnumByValue(Class enumClass, Number value) {
        Enum var3;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(enumClass.getClassLoader());
            var3 = (Enum)EnumUtil.getEnumType((Class)enumClass).valueMap.get(value);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return var3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enum getEnumByValue(Class enumClass, int value) {
        Enum var3;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(enumClass.getClassLoader());
            var3 = (Enum)EnumUtil.getEnumType((Class)enumClass).valueMap.get(new Integer(value));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return var3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enum getEnumByValue(Class enumClass, long value) {
        Enum var4;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(enumClass.getClassLoader());
            var4 = (Enum)EnumUtil.getEnumType((Class)enumClass).valueMap.get(new Long(value));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getEnumMap(Class enumClass) {
        Map var2;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(enumClass.getClassLoader());
            var2 = Collections.unmodifiableMap(EnumUtil.getEnumType((Class)enumClass).nameMap);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getEnumIterator(Class enumClass) {
        Iterator var2;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(enumClass.getClassLoader());
            var2 = EnumUtil.getEnumType((Class)enumClass).enumList.iterator();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getEnumEntryMap(Class enumClass) {
        ClassLoader classLoader = enumClass.getClassLoader();
        ConcurrentHashMap entryMap = null;
        Map map = entries;
        synchronized (map) {
            entryMap = (ConcurrentHashMap)entries.get(classLoader);
            if (entryMap == null) {
                entryMap = new ConcurrentHashMap();
                entries.put(classLoader, entryMap);
            }
            return entryMap;
        }
    }

    static Enum.EnumType getEnumType(Class enumClass) {
        if (enumClass == null) {
            throw new NullPointerException("The Enum class must not be null");
        }
        if (!Enum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException(MessageFormat.format("Class \"{0}\" is not a subclass of Enum", enumClass.getName()));
        }
        ConcurrentHashMap entryMap = (ConcurrentHashMap)EnumUtil.getEnumEntryMap(enumClass);
        Enum.EnumType enumType = (Enum.EnumType)entryMap.get(enumClass.getName());
        if (enumType == null) {
            Method createEnumTypeMethod = EnumUtil.findStaticMethod(enumClass, "createEnumType", new Class[0]);
            if (createEnumTypeMethod != null) {
                try {
                    enumType = (Enum.EnumType)createEnumTypeMethod.invoke((Object)null, new Object[0]);
                }
                catch (IllegalAccessException var5) {
                    throw new RuntimeException(var5);
                }
                catch (IllegalArgumentException var6) {
                    throw new RuntimeException(var6);
                }
                catch (InvocationTargetException var7) {
                    throw new RuntimeException(var7);
                }
                catch (ClassCastException var8) {
                    throw new RuntimeException(var8);
                }
            }
            if (enumType != null) {
                enumType.populateNames(enumClass);
                Enum.EnumType existing = entryMap.putIfAbsent(enumClass.getName(), enumType);
                if (existing != null) {
                    enumType = existing;
                }
            }
        }
        if (enumType == null) {
            throw new UnsupportedOperationException(MessageFormat.format("Could not create EnumType for class \"{0}\"", enumClass.getName()));
        }
        return enumType;
    }

    private static Method findStaticMethod(Class enumClass, String methodName, Class[] paramTypes) {
        Method method = null;
        Class clazz = enumClass;
        while (!clazz.equals(Enum.class)) {
            try {
                method = clazz.getDeclaredMethod(methodName, paramTypes);
                break;
            }
            catch (NoSuchMethodException var6) {
                clazz = clazz.getSuperclass();
            }
        }
        return method != null && Modifier.isStatic(method.getModifiers()) ? method : null;
    }
}

