/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.util;

import com.alipay.api.FileItem;
import com.alipay.api.internal.util.AbstractHttpClient;
import com.alipay.api.internal.util.AlipayLogger;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.WebUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientUtil
extends AbstractHttpClient {
    public static final ConcurrentHashMap<String, OkHttpClient> clients = new ConcurrentHashMap();
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";
    private static HostnameVerifier verifier = null;
    private static SSLSocketFactory socketFactory = null;
    private static X509TrustManager trustManager = null;

    @Override
    public String doPost(String url, Map<String, String> params, String charset, Map<String, String> resHeaders) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return this.execute(METHOD_POST, ctype, content, url, charset, this.getConnectTimeout(), this.getReadTimeout(), this.getMaxIdleConnections(), this.getKeepAliveDuration(), this.getProxyHost(), this.getProxyPort(), this.getCustomHeaders(), resHeaders);
    }

    @Override
    public String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, Map<String, String> resHeaders) throws IOException {
        if (fileParams == null || fileParams.isEmpty()) {
            this.doPost(url, params, charset, resHeaders);
        }
        String boundary = System.currentTimeMillis() + "";
        String ctype = "multipart/form-data;boundary=" + boundary + ";charset=" + charset;
        byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(charset);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Set<Map.Entry<String, String>> textEntrySet = params.entrySet();
        for (Map.Entry<String, String> entry : textEntrySet) {
            byte[] byArray = WebUtils.getTextEntry(entry.getKey(), entry.getValue(), charset);
            stream.write(entryBoundaryBytes);
            stream.write(byArray);
        }
        Set<Map.Entry<String, FileItem>> fileEntrySet = fileParams.entrySet();
        for (Map.Entry<String, FileItem> entry : fileEntrySet) {
            FileItem fileItem = entry.getValue();
            byte[] fileBytes = WebUtils.getFileEntry(entry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), charset);
            stream.write(entryBoundaryBytes);
            stream.write(fileBytes);
            stream.write(fileItem.getContent());
        }
        byte[] byArray = ("\r\n--" + boundary + "--\r\n").getBytes(charset);
        stream.write(byArray);
        byte[] byArray2 = stream.toByteArray();
        return this.execute(METHOD_POST, ctype, byArray2, url, charset, this.getConnectTimeout(), this.getReadTimeout(), this.getMaxIdleConnections(), this.getKeepAliveDuration(), this.getProxyHost(), this.getProxyPort(), this.getCustomHeaders(), resHeaders);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String execute(String methodType, String ctype, byte[] content, String url, String charset, int connectTimeout, int readTimeout, int maxIdleConnections, long keepAliveDuration, String proxyHost, int proxyPort, Map<String, String> headers, Map<String, String> resHeaders) throws IOException {
        String rsp;
        Response response;
        block12: {
            String string;
            block11: {
                response = null;
                try {
                    try {
                        URL netUrl = new URL(url);
                        String key = !StringUtils.isEmpty(proxyHost) ? String.format("%s:%d", proxyHost, proxyPort) : String.format("%s:%d", netUrl.getHost(), netUrl.getPort());
                        OkHttpClient okHttpClient = clients.get(key);
                        if (okHttpClient == null) {
                            okHttpClient = this.getOkHttpClient(netUrl, connectTimeout, readTimeout, maxIdleConnections, keepAliveDuration, proxyHost, proxyPort);
                            clients.put(key, okHttpClient);
                        }
                        if (METHOD_POST.equals(methodType)) {
                            response = okHttpClient.newCall(this.getOkRequestBuilder(netUrl, headers, ctype).post(RequestBody.create((MediaType)MediaType.parse((String)ctype), (byte[])content)).build()).execute();
                        } else if (METHOD_GET.equals(methodType)) {
                            response = okHttpClient.newCall(this.getOkRequestBuilder(netUrl, headers, ctype).get().build()).execute();
                        }
                        if (response == null) {
                            string = null;
                            Object var22_21 = null;
                            if (response == null) return string;
                            break block11;
                        }
                        rsp = this.getResponseAsString(response, charset);
                        if (resHeaders != null) {
                            resHeaders.put("trace_id", response.header("trace_id"));
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        Map<String, String> map = WebUtils.getParamsFromUrl(url);
                        AlipayLogger.logCommError((Exception)e, url, map.get("app_key"), map.get("method"), content);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var22_23 = null;
                    if (response == null) throw throwable;
                    response.close();
                    throw throwable;
                }
            }
            response.close();
            return string;
        }
        Object var22_22 = null;
        if (response == null) return rsp;
        response.close();
        return rsp;
    }

    private OkHttpClient getOkHttpClient(URL url, int connectTimeout, int readTimeout, int maxIdleConnections, long keepAliveDuration, String proxyHost, int proxyPort) throws IOException {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        builder.connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        if (maxIdleConnections > 0) {
            builder.connectionPool(new ConnectionPool(maxIdleConnections, keepAliveDuration, TimeUnit.MILLISECONDS));
        }
        if ("https".equals(url.getProtocol()) && !WebUtils.isNeedCheckServerTrusted()) {
            builder.sslSocketFactory(socketFactory, trustManager).hostnameVerifier(verifier);
        }
        if (!StringUtils.isEmpty(proxyHost)) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
        }
        return builder.build();
    }

    private Request.Builder getOkRequestBuilder(URL url, Map<String, String> headers, String ctype) throws IOException {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        builder.header("Accept", "text/plain,text/xml,text/javascript,text/html");
        builder.header("User-Agent", "aop-sdk-java");
        builder.header("Content-Type", ctype);
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                builder.header(header.getKey(), header.getValue());
            }
        }
        return builder;
    }

    protected String getResponseAsString(Response response, String charset) throws IOException {
        int read;
        InputStream body;
        InputStream inputStream = body = response.body() == null ? null : response.body().byteStream();
        if (null == body || !response.isSuccessful()) {
            throw new IOException(response.code() + ":" + response.message());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        while ((read = body.read(buff)) != -1) {
            os.write(buff, 0, read);
        }
        return os.toString(charset);
    }

    static {
        try {
            trustManager = new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{trustManager}, new SecureRandom());
            ctx.getClientSessionContext().setSessionTimeout(15);
            ctx.getClientSessionContext().setSessionCacheSize(1000);
            socketFactory = ctx.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        verifier = new HostnameVerifier(){

            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }
}

