/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.util.namelist;

import com.alibaba.p3c.pmd.lang.java.util.namelist.NameListService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class NameListServiceImpl
implements NameListService {
    private static final String NAME_LIST_PROPERTY_FILE_NAME = "namelist.properties";
    private static final Properties PROPERTIES = NameListServiceImpl.initProperties();
    private static final String SEPARATOR = "_";

    private static Properties initProperties() {
        LinkedProperties props = new LinkedProperties();
        ClassLoader classLoader = NameListServiceImpl.class.getClassLoader();
        try {
            props.load(classLoader.getResourceAsStream(NAME_LIST_PROPERTY_FILE_NAME));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Load namelist.properties fail", ex);
        }
        return props;
    }

    @Override
    public List<String> getNameList(String className, String name) {
        Gson gson = new Gson();
        return (List)gson.fromJson((String)PROPERTIES.get(className + SEPARATOR + name), new TypeToken<List<String>>(){}.getType());
    }

    @Override
    public <K, V> Map<K, V> getNameMap(String className, String name, Class<K> kClass, Class<V> vClass) {
        Gson gson = new Gson();
        return (Map)gson.fromJson((String)PROPERTIES.get(className + SEPARATOR + name), new TypeToken<Map<K, V>>(){}.getType());
    }

    private static class LinkedProperties
    extends Properties {
        private LinkedHashSet<Object> linkedKeys = new LinkedHashSet();

        private LinkedProperties() {
        }

        @Override
        public Object put(Object key, Object value) {
            this.linkedKeys.add(key);
            return super.put(key, value);
        }

        public int getSize() {
            return this.linkedKeys.size();
        }
    }
}

