/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.naming;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.rule.AbstractRule;

public class AvoidStartWithDollarAndUnderLineNamingRule
extends AbstractAliRule {
    private static final String DOLLAR = "$";
    private static final String UNDERSCORE = "_";
    private static final String FORMAT = I18nResources.getMessage("java.naming.AvoidStartWithDollarAndUnderLineNamingRule.violation.msg");

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.getImage().startsWith(DOLLAR) || node.getImage().startsWith(UNDERSCORE)) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, String.format(FORMAT, node.getImage()));
        }
        return super.visit(node, data);
    }

    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (node.getImage().startsWith(DOLLAR) || node.getImage().startsWith(UNDERSCORE)) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, String.format(FORMAT, node.getImage()));
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclarator node, Object data) {
        if (node.getImage().startsWith(DOLLAR) || node.getImage().startsWith(UNDERSCORE)) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, String.format(FORMAT, node.getImage()));
        }
        return super.visit(node, data);
    }
}

