/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.comment;

import com.alibaba.p3c.pmd.lang.java.rule.comment.AbstractAliCommentRule;
import com.alibaba.p3c.pmd.lang.java.rule.util.NodeSortUtils;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.ast.JavaNode;

public class RemoveCommentedCodeRule
extends AbstractAliCommentRule {
    private static final Pattern SUPPRESS_PATTERN = Pattern.compile("\\s*///.*", 32);
    private static final Pattern PRE_TAG_PATTERN = Pattern.compile(".*<pre>.*", 32);
    private static final Pattern IMPORT_PATTERN = Pattern.compile(".*import\\s(static\\s)?(\\w*\\.)*\\w*;.*", 32);
    private static final Pattern FIELD_PATTERN = Pattern.compile(".*private\\s+(\\w*)\\s+(\\w*);.*", 32);
    private static final Pattern METHOD_PATTERN = Pattern.compile(".*(public|protected|private)\\s+\\w+\\s+\\w+\\(.*\\)\\s+\\{.*", 32);
    private static final Pattern STATEMENT_PATTERN = Pattern.compile(".*\\.\\w+\\(.*\\);\n.*", 32);

    public Object visit(ASTCompilationUnit cUnit, Object data) {
        this.checkCommentsBetweenDeclarations(cUnit, data);
        return super.visit(cUnit, data);
    }

    protected void checkCommentsBetweenDeclarations(ASTCompilationUnit cUnit, Object data) {
        SortedMap<Integer, Node> itemsByLineNumber = this.orderedCommentsAndDeclarations(cUnit);
        Comment lastComment = null;
        boolean suppressWarning = false;
        CommentPatternEnum commentPattern = CommentPatternEnum.NONE;
        for (Map.Entry<Integer, Node> entry : itemsByLineNumber.entrySet()) {
            Node value = entry.getValue();
            if (value instanceof JavaNode) {
                JavaNode node = (JavaNode)value;
                if (lastComment != null && this.isCommentBefore(lastComment, (Node)node)) {
                    if (!CommentPatternEnum.NONE.equals((Object)commentPattern)) {
                        boolean statementOutsideMethod;
                        boolean bl = statementOutsideMethod = CommentPatternEnum.STATEMENT.equals((Object)commentPattern) && !(node instanceof ASTBlockStatement);
                        if (!statementOutsideMethod) {
                            this.addViolationWithMessage(data, (Node)node, this.getMessage(), lastComment.getBeginLine(), lastComment.getEndLine());
                        }
                    }
                    lastComment = null;
                }
                suppressWarning = false;
                commentPattern = CommentPatternEnum.NONE;
                continue;
            }
            if (!(value instanceof Comment)) continue;
            lastComment = (Comment)value;
            String content = lastComment.getImage();
            if (!suppressWarning) {
                suppressWarning = SUPPRESS_PATTERN.matcher(content).matches();
            }
            if (suppressWarning || !CommentPatternEnum.NONE.equals((Object)commentPattern)) continue;
            commentPattern = this.scanCommentedCode(content);
        }
    }

    protected CommentPatternEnum scanCommentedCode(String content) {
        CommentPatternEnum pattern = CommentPatternEnum.NONE;
        if (PRE_TAG_PATTERN.matcher(content).matches()) {
            return pattern;
        }
        if (IMPORT_PATTERN.matcher(content).matches()) {
            pattern = CommentPatternEnum.IMPORT;
        } else if (FIELD_PATTERN.matcher(content).matches()) {
            pattern = CommentPatternEnum.FIELD;
        } else if (METHOD_PATTERN.matcher(content).matches()) {
            pattern = CommentPatternEnum.METHOD;
        } else if (STATEMENT_PATTERN.matcher(content).matches()) {
            pattern = CommentPatternEnum.STATEMENT;
        }
        return pattern;
    }

    protected SortedMap<Integer, Node> orderedCommentsAndDeclarations(ASTCompilationUnit cUnit) {
        TreeMap<Integer, Node> itemsByLineNumber = new TreeMap<Integer, Node>();
        List importDecl = cUnit.findDescendantsOfType(ASTImportDeclaration.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, importDecl);
        List classDecl = cUnit.findDescendantsOfType(ASTClassOrInterfaceDeclaration.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, classDecl);
        List fields = cUnit.findDescendantsOfType(ASTFieldDeclaration.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, fields);
        List methods = cUnit.findDescendantsOfType(ASTMethodDeclaration.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, methods);
        List constructors = cUnit.findDescendantsOfType(ASTConstructorDeclaration.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, constructors);
        List blockStatements = cUnit.findDescendantsOfType(ASTBlockStatement.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, blockStatements);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, cUnit.getComments());
        return itemsByLineNumber;
    }

    private boolean isCommentBefore(Comment n1, Node n2) {
        return n1.getEndLine() < n2.getBeginLine() || n1.getEndLine() == n2.getBeginLine() && n1.getEndColumn() < n2.getBeginColumn();
    }

    static enum CommentPatternEnum {
        IMPORT,
        FIELD,
        METHOD,
        STATEMENT,
        NONE;

    }
}

