/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.pathencoder;

import com.alibaba.nacos.common.pathencoder.PathEncoder;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import java.nio.charset.Charset;
import java.util.Collection;

public class PathEncoderManager {
    private static final PathEncoderManager INSTANCE = new PathEncoderManager();
    private PathEncoder targetEncoder = null;

    private PathEncoderManager() {
        Collection<PathEncoder> load = NacosServiceLoader.load(PathEncoder.class);
        if (!load.isEmpty()) {
            String currentOs = System.getProperty("os.name").toLowerCase();
            for (PathEncoder pathEncoder : load) {
                if (!currentOs.contains(pathEncoder.name())) continue;
                this.targetEncoder = pathEncoder;
                break;
            }
        }
    }

    public String encode(String path, String charset) {
        if (path == null || charset == null) {
            return path;
        }
        if (this.targetEncoder != null && this.targetEncoder.needEncode(path)) {
            return this.targetEncoder.encode(path, charset);
        }
        return path;
    }

    public String encode(String path) {
        return this.encode(path, Charset.defaultCharset().name());
    }

    public String decode(String path, String charset) {
        if (path == null || charset == null) {
            return path;
        }
        if (this.targetEncoder != null) {
            return this.targetEncoder.decode(path, charset);
        }
        return path;
    }

    public String decode(String path) {
        return this.decode(path, Charset.defaultCharset().name());
    }

    public static PathEncoderManager getInstance() {
        return INSTANCE;
    }
}

