/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.beat;

import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.client.naming.beat.BeatInfo;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.LogUtils;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class BeatReactor {
    private ScheduledExecutorService executorService;
    private long clientBeatInterval = 5000L;
    private NamingProxy serverProxy;
    public final Map<String, BeatInfo> dom2Beat = new ConcurrentHashMap<String, BeatInfo>();

    public BeatReactor(NamingProxy serverProxy) {
        this(serverProxy, UtilAndComs.DEFAULT_CLIENT_BEAT_THREAD_COUNT);
    }

    public BeatReactor(NamingProxy serverProxy, int threadCount) {
        this.serverProxy = serverProxy;
        this.executorService = new ScheduledThreadPoolExecutor(threadCount, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("com.alibaba.nacos.naming.beat.sender");
                return thread;
            }
        });
        this.executorService.scheduleAtFixedRate(new BeatProcessor(), 0L, this.clientBeatInterval, TimeUnit.MILLISECONDS);
    }

    public void addBeatInfo(String dom, BeatInfo beatInfo) {
        LogUtils.LOG.info("BEAT", "adding beat: {} to beat map.", beatInfo);
        this.dom2Beat.put(this.buildKey(dom, beatInfo.getIp(), beatInfo.getPort()), beatInfo);
        MetricsMonitor.getDom2BeatSizeMonitor().set(this.dom2Beat.size());
    }

    public void removeBeatInfo(String dom, String ip, int port) {
        LogUtils.LOG.info("BEAT", "removing beat: {}:{}:{} from beat map.", dom, ip, port);
        this.dom2Beat.remove(this.buildKey(dom, ip, port));
        MetricsMonitor.getDom2BeatSizeMonitor().set(this.dom2Beat.size());
    }

    public String buildKey(String dom, String ip, int port) {
        return dom + "#" + ip + "#" + port;
    }

    class BeatTask
    implements Runnable {
        BeatInfo beatInfo;

        public BeatTask(BeatInfo beatInfo) {
            this.beatInfo = beatInfo;
        }

        @Override
        public void run() {
            long result = BeatReactor.this.serverProxy.sendBeat(this.beatInfo);
            this.beatInfo.setScheduled(false);
            if (result > 0L) {
                BeatReactor.this.clientBeatInterval = result;
            }
        }
    }

    class BeatProcessor
    implements Runnable {
        BeatProcessor() {
        }

        @Override
        public void run() {
            try {
                for (Map.Entry<String, BeatInfo> entry : BeatReactor.this.dom2Beat.entrySet()) {
                    BeatInfo beatInfo = entry.getValue();
                    if (beatInfo.isScheduled()) continue;
                    beatInfo.setScheduled(true);
                    BeatReactor.this.executorService.schedule(new BeatTask(beatInfo), 0L, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                LogUtils.LOG.error("CLIENT-BEAT", "Exception while scheduling beat.", e);
            }
        }
    }
}

