/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.api;

public class AuthResult<T> {
    private static final String MESSAGE_FORMAT = "Code: %d, Message: %s.";
    private boolean success;
    private int errorCode;
    private String errorMessage;
    private T data;

    public static AuthResult successResult() {
        AuthResult result = new AuthResult();
        result.setSuccess(true);
        return result;
    }

    public static AuthResult successResult(Object data) {
        AuthResult<Object> result = new AuthResult<Object>();
        result.setSuccess(true);
        result.setData(data);
        return result;
    }

    public static AuthResult failureResult(int errorCode, String errorMessage) {
        AuthResult result = new AuthResult();
        result.setSuccess(false);
        result.setErrorCode(errorCode);
        result.setErrorMessage(errorMessage);
        return result;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String format() {
        return String.format(MESSAGE_FORMAT, this.errorCode, this.errorMessage);
    }
}

