/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics;

import com.alibaba.metrics.Clock;
import com.alibaba.metrics.Gauge;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class CachedGauge<T>
implements Gauge<T> {
    private final Clock clock;
    private final AtomicLong reloadAt;
    private final long timeoutNS;
    private long lastUpdate = System.currentTimeMillis();
    private volatile T value;

    protected CachedGauge(long timeout, TimeUnit timeoutUnit) {
        this(Clock.defaultClock(), timeout, timeoutUnit);
    }

    protected CachedGauge(Clock clock, long timeout, TimeUnit timeoutUnit) {
        this.clock = clock;
        this.reloadAt = new AtomicLong(clock.getTick());
        this.timeoutNS = timeoutUnit.toNanos(timeout);
    }

    protected abstract T loadValue();

    @Override
    public T getValue() {
        if (this.shouldLoad()) {
            this.value = this.loadValue();
            this.lastUpdate = System.currentTimeMillis();
        }
        return this.value;
    }

    @Override
    public long lastUpdateTime() {
        return this.lastUpdate;
    }

    private boolean shouldLoad() {
        long currentTick;
        long reloadAtTick;
        do {
            if ((currentTick = this.clock.getTick()) >= (reloadAtTick = this.reloadAt.get())) continue;
            return false;
        } while (!this.reloadAt.compareAndSet(reloadAtTick, currentTick + this.timeoutNS));
        return true;
    }
}

