/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseAPIProxyDirectImpl;
import com.alibaba.hbase.client.AliHBaseUEConnection;
import com.alibaba.hbase.client.ElementConvertor;
import com.alibaba.lindorm.client.TableService;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterMetricsBuilder;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AliHBaseAdminInterface;
import org.apache.hadoop.hbase.client.AliHBaseUEClusterConnection;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.index.AliHBaseIndexDescriptor;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliHBaseUEAdmin
extends HBaseAdmin
implements AliHBaseAdminInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AliHBaseUEAdmin.class);
    private AliHBaseUEConnection connection;
    private AliHBaseUEClusterConnection clusterConnection;
    private int operationTimeout;
    private Configuration conf;
    private AliHBaseAPIProxy proxy;
    private static AliHBaseUEClusterConnection superConnection = null;

    private static AliHBaseUEClusterConnection getSuperConnection(AliHBaseUEConnection connection) throws IOException {
        if (superConnection == null || superConnection.isClosed()) {
            superConnection = new AliHBaseUEClusterConnection(connection);
        }
        return superConnection;
    }

    public AliHBaseUEAdmin(AliHBaseUEConnection connection) throws IOException {
        super((ClusterConnection)AliHBaseUEAdmin.getSuperConnection(connection));
        this.connection = connection;
        this.clusterConnection = new AliHBaseUEClusterConnection(connection);
        this.conf = connection.getConfiguration();
        this.operationTimeout = connection.getOperationTimeout();
        this.proxy = connection.getAPIProxy(null);
    }

    public TableService getTableService(String namespace) throws IOException {
        if (this.proxy instanceof AliHBaseAPIProxyDirectImpl) {
            return ((AliHBaseAPIProxyDirectImpl)this.proxy).getTableService(namespace);
        }
        return null;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void abort(String why, Throwable e) {
    }

    public boolean isAborted() {
        return false;
    }

    public void close() throws IOException {
        this.proxy.close();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public boolean tableExists(TableName tableName) throws IOException {
        return this.proxy.tableExists(tableName);
    }

    public Connection getConnection() {
        return this.clusterConnection;
    }

    public HTableDescriptor[] listTables() throws IOException {
        List<TableDescriptor> tableDescriptors = this.listTableDescriptors();
        HTableDescriptor[] hTableDescriptors = new HTableDescriptor[tableDescriptors.size()];
        for (int i = 0; i < tableDescriptors.size(); ++i) {
            hTableDescriptors[i] = new HTableDescriptor(tableDescriptors.get(i));
        }
        return hTableDescriptors;
    }

    public List<TableDescriptor> listTableDescriptors() throws IOException {
        return this.proxy.listTableDescriptors();
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        ArrayList<HTableDescriptor> result = new ArrayList<HTableDescriptor>();
        List<TableDescriptor> tableDescriptors = this.listTableDescriptors();
        for (int i = 0; i < tableDescriptors.size(); ++i) {
            Matcher matcher = pattern.matcher(tableDescriptors.get(i).getTableName().getNameAsString());
            if (!matcher.matches()) continue;
            result.add(new HTableDescriptor(tableDescriptors.get(i)));
        }
        return result.toArray(new HTableDescriptor[0]);
    }

    public List<TableDescriptor> listTableDescriptors(Pattern pattern) throws IOException {
        return this.listTableDescriptors();
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables();
    }

    public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTables();
    }

    public List<TableDescriptor> listTableDescriptors(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTableDescriptors();
    }

    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        return this.listTables();
    }

    public TableName[] listTableNames() throws IOException {
        return this.proxy.listTableNames();
    }

    public TableName[] listTableNames(Pattern pattern) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(String regex) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        return this.listTableNames();
    }

    public HTableDescriptor getTableDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        TableDescriptor tableDescriptor = this.getDescriptor(tableName);
        return new HTableDescriptor(tableDescriptor);
    }

    public TableDescriptor getDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        return this.proxy.getDescriptor(tableName);
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
        List<TableDescriptor> descriptors = this.listTableDescriptorsByNamespace(Bytes.toBytes((String)name));
        HTableDescriptor[] hTableDescriptors = new HTableDescriptor[descriptors.size()];
        for (int i = 0; i < descriptors.size(); ++i) {
            hTableDescriptors[i] = new HTableDescriptor(descriptors.get(i));
        }
        return hTableDescriptors;
    }

    public List<TableDescriptor> listTableDescriptorsByNamespace(byte[] name) throws IOException {
        return this.proxy.listTableDescriptorsByNamespace(name);
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        return this.proxy.listTableNamesByNamespace(name);
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        HTableDescriptor[] tableDescriptors = new HTableDescriptor[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tableDescriptors[i] = this.getTableDescriptor(tableNames.get(i));
        }
        return tableDescriptors;
    }

    public List<TableDescriptor> listTableDescriptors(List<TableName> tableNames) throws IOException {
        ArrayList<TableDescriptor> tableDescriptors = new ArrayList<TableDescriptor>();
        for (TableName tableName : tableNames) {
            tableDescriptors.add(this.getDescriptor(tableName));
        }
        return tableDescriptors;
    }

    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        List<TableName> tableNames = names.stream().map(name -> TableName.valueOf((String)name)).collect(Collectors.toList());
        return this.getTableDescriptorsByTableName(tableNames);
    }

    public void createTable(TableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(TableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(TableDescriptor desc, byte[][] splitKeys) throws IOException {
        TableName.isLegalFullyQualifiedTableName((byte[])desc.getTableName().getName());
        this.proxy.createTable(desc, splitKeys);
    }

    public void deleteTable(TableName tableName) throws IOException {
        this.proxy.deleteTable(tableName);
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        this.proxy.truncateTable(tableName, preserveSplits);
    }

    public void enableTable(TableName tableName) throws IOException {
        this.proxy.enableTable(tableName);
    }

    public void disableTable(TableName tableName) throws IOException {
        this.proxy.disableTable(tableName);
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.proxy.isTableEnabled(tableName);
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.proxy.isTableDisabled(tableName);
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.isTableEnabled(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        boolean enable = this.isTableEnabled(tableName);
        if (enable) {
            try (AliHBaseAPIProxy localProxy = null;){
                localProxy = this.connection.getAPIProxy(tableName);
                Pair<byte[][], byte[][]> pair = localProxy.getStartEndKeys();
                byte[][] startKeys = (byte[][])pair.getFirst();
                byte[][] endKeys = (byte[][])pair.getSecond();
                if (startKeys.length != splitKeys.length + 1 || endKeys.length != splitKeys.length + 1) {
                    boolean bl = false;
                    return bl;
                }
                for (int i = 0; i < splitKeys.length; ++i) {
                    if (Bytes.equals((byte[])startKeys[i + 1], (byte[])splitKeys[i]) && Bytes.equals((byte[])endKeys[i], (byte[])splitKeys[i])) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = enable;
                return bl;
            }
        }
        return enable;
    }

    public void addColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        this.proxy.addColumnFamily(tableName, columnFamily);
    }

    public void deleteColumn(TableName tableName, byte[] columnFamily) throws IOException {
        this.deleteColumnFamily(tableName, columnFamily);
    }

    public void deleteColumnFamily(TableName tableName, byte[] columnFamily) throws IOException {
        this.proxy.deleteColumnFamily(tableName, columnFamily);
    }

    public void modifyColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        this.proxy.modifyColumnFamily(tableName, columnFamily);
    }

    public void modifyTable(TableName tableName, TableDescriptor td) throws IOException {
        this.modifyTable(td);
    }

    public void modifyTable(TableDescriptor td) throws IOException {
        this.proxy.modifyTable(td);
    }

    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
    }

    public void deleteNamespace(String name) throws IOException {
        this.proxy.deleteNamespace(name);
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        return this.proxy.getNamespaceDescriptor(name);
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        return this.proxy.listNamespaceDescriptors();
    }

    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        String namespace = descriptor.getName();
        TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)namespace));
        this.proxy.createNamespace(descriptor);
    }

    public void flush(TableName tableName) {
        this.proxy.flushTable(tableName);
    }

    public void flushRegion(byte[] regionName) {
        this.proxy.flushRegion(Bytes.toString((byte[])regionName));
    }

    public void compact(TableName tableName) {
        this.proxy.compactTable(tableName);
    }

    public void compactRegion(byte[] regionName) {
        this.proxy.compactRegion(Bytes.toString((byte[])regionName));
    }

    public void compact(TableName tableName, byte[] columnFamily) {
        this.compact(tableName);
    }

    public void compactRegion(byte[] regionName, byte[] columnFamily) {
        this.compactRegion(regionName);
    }

    public void compact(TableName tableName, CompactType compactType) {
        this.compact(tableName);
    }

    public void compact(TableName tableName, byte[] columnFamily, CompactType compactType) {
        this.compact(tableName);
    }

    public void majorCompact(TableName tableName) {
        this.proxy.majorCompactTable(tableName);
    }

    public void majorCompactRegion(byte[] regionName) {
        this.proxy.majorCompactRegion(Bytes.toString((byte[])regionName));
    }

    public void majorCompact(TableName tableName, byte[] columnFamily) {
        this.majorCompact(tableName);
    }

    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) {
        this.majorCompactRegion(regionName);
    }

    public void majorCompact(TableName tableName, CompactType compactType) {
        this.majorCompact(tableName);
    }

    public void majorCompact(TableName tableName, byte[] columnFamily, CompactType compactType) {
        this.majorCompact(tableName);
    }

    public boolean switchRpcThrottle(boolean enable) throws IOException {
        return false;
    }

    public boolean isRpcThrottleEnabled() throws IOException {
        return false;
    }

    public boolean exceedThrottleQuotaSwitch(boolean enable) throws IOException {
        return false;
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.disableTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableEnabled(table.getTableName())) continue;
            try {
                this.disableTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info("Failed to enable table " + table.getTableName(), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.enableTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableDisabled(table.getTableName())) continue;
            try {
                this.enableTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info("Failed to enable table " + table.getTableName(), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        throw new UnsupportedOperationException("deleteTables by pattern not supported");
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("deleteTables by pattern not supported");
    }

    public void closeRegion(String regionname, String serverName) {
    }

    public void closeRegion(byte[] regionname, String serverName) {
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) {
        return true;
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) {
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) {
        return new ArrayList<HRegionInfo>();
    }

    public List<RegionInfo> getRegions(ServerName serverName) {
        return new ArrayList<RegionInfo>();
    }

    public void flushRegionServer(ServerName serverName) {
    }

    public Map<ServerName, Boolean> compactionSwitch(boolean switchState, List<String> serverNamesList) {
        return new HashMap<ServerName, Boolean>();
    }

    public void compactRegionServer(ServerName serverName) {
    }

    public void majorCompactRegionServer(ServerName serverName) {
    }

    public void move(byte[] encodedRegionName) {
    }

    public void move(byte[] encodedRegionName, ServerName destServerName) {
    }

    public void assign(byte[] regionName) {
    }

    public void unassign(byte[] regionName, boolean force) {
    }

    public void offline(byte[] regionName) {
    }

    public boolean balancerSwitch(boolean onOrOff, boolean synchronous) {
        return true;
    }

    public boolean balance() {
        return true;
    }

    public boolean balance(boolean force) {
        return true;
    }

    public boolean isBalancerEnabled() {
        return true;
    }

    public CacheEvictionStats clearBlockCache(TableName tableName) {
        return null;
    }

    public boolean normalize() {
        return false;
    }

    public boolean isNormalizerEnabled() {
        return false;
    }

    public boolean normalizerSwitch(boolean on) {
        return false;
    }

    public boolean catalogJanitorSwitch(boolean onOrOff) {
        return true;
    }

    public int runCatalogJanitor() {
        return 0;
    }

    public boolean isCatalogJanitorEnabled() {
        return true;
    }

    public boolean cleanerChoreSwitch(boolean onOrOff) {
        return true;
    }

    public boolean runCleanerChore() {
        return false;
    }

    public boolean isCleanerChoreEnabled() {
        return true;
    }

    public void mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) {
        String regionA = Bytes.toString((byte[])nameOfRegionA);
        String regionB = Bytes.toString((byte[])nameOfRegionB);
        String[] splitA = regionA.split(",");
        String[] splitB = regionB.split(",");
        Preconditions.checkArgument((splitA.length > 1 && splitB.length > 1 ? 1 : 0) != 0, (Object)"only support full region name");
        String tableNameA = splitA[0];
        String tableNameB = splitB[0];
        Preconditions.checkArgument((boolean)StringUtils.equals((String)tableNameA, (String)tableNameB), (Object)"regions to be merged should belong to the same table");
        String shortNameA = regionA.split("\\.")[2];
        String shortNameB = regionB.split("\\.")[2];
        this.proxy.mergeRegions(tableNameA, shortNameA, shortNameB);
    }

    public Future<Void> mergeRegionsAsync(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) {
        this.mergeRegions(nameOfRegionA, nameOfRegionB, forcible);
        return this.getVoidFuture();
    }

    public Future<Void> mergeRegionsAsync(byte[][] nameofRegionsToMerge, boolean forcible) {
        throw new UnsupportedOperationException("mergeRegionsAsync not supported");
    }

    public void split(TableName tableName) {
        String table = ElementConvertor.toLindormTableFullName(tableName);
        this.proxy.split(table, null);
    }

    public void splitRegion(byte[] regionName) {
        this.proxy.split(Bytes.toString((byte[])regionName), null);
    }

    public void split(TableName tableName, byte[] splitPoint) {
        String table = ElementConvertor.toLindormTableFullName(tableName);
        this.proxy.split(table, splitPoint);
    }

    public void splitRegion(byte[] regionName, byte[] splitPoint) {
        this.proxy.split(Bytes.toString((byte[])regionName), splitPoint);
    }

    public Future<Void> splitRegionAsync(byte[] regionName, byte[] splitPoint) {
        this.splitRegion(regionName, splitPoint);
        return this.getVoidFuture();
    }

    public Future<Void> modifyTableAsync(TableName tableName, TableDescriptor td) throws IOException {
        this.modifyTable(tableName, td);
        return this.getVoidFuture();
    }

    public Future<Void> modifyTableAsync(TableDescriptor td) throws IOException {
        this.modifyTable(td);
        return this.getVoidFuture();
    }

    public void shutdown() {
    }

    public void stopMaster() {
    }

    public boolean isMasterInMaintenanceMode() {
        return false;
    }

    public void stopRegionServer(String hostnamePort) {
    }

    public ClusterMetrics getClusterMetrics(EnumSet<ClusterMetrics.Option> options) {
        ClusterMetricsBuilder clusterMetricsBuilder = ClusterMetricsBuilder.newBuilder();
        return clusterMetricsBuilder.build();
    }

    public List<RegionMetrics> getRegionMetrics(ServerName serverName, TableName tableName) {
        ArrayList<RegionMetrics> metricses = new ArrayList<RegionMetrics>();
        return metricses;
    }

    public Future<Void> createNamespaceAsync(NamespaceDescriptor descriptor) throws IOException {
        this.createNamespace(descriptor);
        return this.getVoidFuture();
    }

    public Future<Void> modifyNamespaceAsync(NamespaceDescriptor descriptor) throws IOException {
        this.modifyNamespace(descriptor);
        return this.getVoidFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
        try (AliHBaseAPIProxy localProxy = null;){
            localProxy = this.connection.getAPIProxy(tableName);
            List<HRegionLocation> list = localProxy.getAllRegionLocations();
            ArrayList<HRegionInfo> result = new ArrayList<HRegionInfo>(list.size());
            for (HRegionLocation location : list) {
                result.add((HRegionInfo)location.getRegion());
            }
            ArrayList<HRegionInfo> arrayList = result;
            return arrayList;
        }
    }

    public List<RegionInfo> getRegions(TableName tableName) {
        if (TableName.isMetaTableName((TableName)tableName)) {
            return Arrays.asList(RegionInfoBuilder.FIRST_META_REGIONINFO);
        }
        return new ArrayList<RegionInfo>();
    }

    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) {
        return false;
    }

    public Future<Boolean> abortProcedureAsync(long procId, boolean mayInterruptIfRunning) {
        return new Future<Boolean>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public Boolean get() throws InterruptedException, ExecutionException {
                return false;
            }

            @Override
            public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return false;
            }
        };
    }

    public String getProcedures() {
        return "";
    }

    public String getLocks() {
        return "";
    }

    public void rollWALWriter(ServerName serverName) {
    }

    public CompactionState getCompactionState(TableName tableName) {
        return CompactionState.NONE;
    }

    public CompactionState getCompactionState(TableName tableName, CompactType compactType) {
        return CompactionState.NONE;
    }

    public CompactionState getCompactionStateForRegion(byte[] regionName) {
        return CompactionState.NONE;
    }

    public long getLastMajorCompactionTimestamp(TableName tableName) {
        return 0L;
    }

    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) {
        return 0L;
    }

    public void snapshot(String snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(byte[] snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(String snapshotName, TableName tableName, SnapshotType type) {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(SnapshotDescription snapshot) {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshotAsync(SnapshotDescription snapshot) {
        throw new UnsupportedOperationException("snapshotAsync not supported");
    }

    public boolean isSnapshotFinished(SnapshotDescription snapshot) {
        throw new UnsupportedOperationException("isSnapshotFinished not supported");
    }

    public void restoreSnapshot(byte[] snapshotName) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(String snapshotName) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public Future<Void> restoreSnapshotAsync(String snapshotName) {
        throw new UnsupportedOperationException("restoreSnapshotAsync not supported");
    }

    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot, boolean restoreAcl) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void cloneSnapshot(byte[] snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName, boolean restoreAcl) {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public Future<Void> cloneSnapshotAsync(String snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("cloneSnapshotAsync not supported");
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) {
        throw new UnsupportedOperationException("execProcedure not supported");
    }

    public byte[] execProcedureWithReturn(String signature, String instance, Map<String, String> props) {
        throw new UnsupportedOperationException("execProcedureWithReturn not supported");
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) {
        throw new UnsupportedOperationException("isProcedureFinished not supported");
    }

    public List<SnapshotDescription> listSnapshots() {
        throw new UnsupportedOperationException("listSnapshots not supported");
    }

    public List<SnapshotDescription> listSnapshots(String regex) {
        throw new UnsupportedOperationException("listSnapshots not supported");
    }

    public List<SnapshotDescription> listSnapshots(Pattern pattern) {
        throw new UnsupportedOperationException("listSnapshots not supported");
    }

    public List<SnapshotDescription> listTableSnapshots(String tableNameRegex, String snapshotNameRegex) {
        throw new UnsupportedOperationException("listTableSnapshots not supported");
    }

    public List<SnapshotDescription> listTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        throw new UnsupportedOperationException("listTableSnapshots not supported");
    }

    public void deleteSnapshot(byte[] snapshotName) {
        throw new UnsupportedOperationException("deleteSnapshot not supported");
    }

    public void deleteSnapshot(String snapshotName) {
        throw new UnsupportedOperationException("deleteSnapshot not supported");
    }

    public void deleteSnapshots(String regex) {
        throw new UnsupportedOperationException("deleteSnapshots not supported");
    }

    public void deleteSnapshots(Pattern pattern) {
        throw new UnsupportedOperationException("deleteSnapshots not supported");
    }

    public void deleteTableSnapshots(String tableNameRegex, String snapshotNameRegex) {
        throw new UnsupportedOperationException("deleteTableSnapshots not supported");
    }

    public void deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        throw new UnsupportedOperationException("deleteTableSnapshots not supported");
    }

    public void setQuota(QuotaSettings quota) {
        throw new UnsupportedOperationException("setQuota not supported");
    }

    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) {
        throw new UnsupportedOperationException("getQuotaRetriever not supported");
    }

    public List<QuotaSettings> getQuota(QuotaFilter filter) {
        throw new UnsupportedOperationException("getQuota not supported");
    }

    public CoprocessorRpcChannel coprocessorService() {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    public CoprocessorRpcChannel coprocessorService(ServerName serverName) {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    public void updateConfiguration(ServerName server) {
    }

    public void updateConfiguration() {
    }

    public List<SecurityCapability> getSecurityCapabilities() {
        return new ArrayList<SecurityCapability>();
    }

    public boolean splitSwitch(boolean enabled, boolean synchronous) {
        return true;
    }

    public boolean mergeSwitch(boolean enabled, boolean synchronous) {
        return true;
    }

    public boolean isSplitEnabled() {
        return true;
    }

    public boolean isMergeEnabled() {
        return true;
    }

    public void addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) {
        throw new UnsupportedOperationException("addReplicationPeer not supported");
    }

    public Future<Void> addReplicationPeerAsync(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) {
        throw new UnsupportedOperationException("addReplicationPeerAsync not supported");
    }

    public void removeReplicationPeer(String peerId) {
        throw new UnsupportedOperationException("removeReplicationPeer not supported");
    }

    public Future<Void> removeReplicationPeerAsync(String peerId) {
        throw new UnsupportedOperationException("removeReplicationPeerAsync not supported");
    }

    public void enableReplicationPeer(String peerId) {
        throw new UnsupportedOperationException("enableReplicationPeer not supported");
    }

    public Future<Void> enableReplicationPeerAsync(String peerId) {
        throw new UnsupportedOperationException("enableReplicationPeerAsync not supported");
    }

    public void disableReplicationPeer(String peerId) {
        throw new UnsupportedOperationException("disableReplicationPeer not supported");
    }

    public Future<Void> disableReplicationPeerAsync(String peerId) {
        throw new UnsupportedOperationException("disableReplicationPeerAsync not supported");
    }

    public ReplicationPeerConfig getReplicationPeerConfig(String peerId) {
        throw new UnsupportedOperationException("getReplicationPeerConfig not supported");
    }

    public void updateReplicationPeerConfig(String peerId, ReplicationPeerConfig peerConfig) {
        throw new UnsupportedOperationException("updateReplicationPeerConfig not supported");
    }

    public Future<Void> updateReplicationPeerConfigAsync(String peerId, ReplicationPeerConfig peerConfig) {
        throw new UnsupportedOperationException("updateReplicationPeerConfigAsync not supported");
    }

    public void appendReplicationPeerTableCFs(String id, Map<TableName, List<String>> tableCfs) throws ReplicationException, IOException {
        throw new UnsupportedOperationException("appendReplicationPeerTableCFs not supported");
    }

    public void removeReplicationPeerTableCFs(String id, Map<TableName, List<String>> tableCfs) throws ReplicationException, IOException {
        throw new UnsupportedOperationException("removeReplicationPeerTableCFs not supported");
    }

    public List<ReplicationPeerDescription> listReplicationPeers() {
        throw new UnsupportedOperationException("listReplicationPeers not supported");
    }

    public List<ReplicationPeerDescription> listReplicationPeers(Pattern pattern) {
        throw new UnsupportedOperationException("listReplicationPeers not supported");
    }

    public void decommissionRegionServers(List<ServerName> servers, boolean offload) {
    }

    public List<ServerName> listDecommissionedRegionServers() {
        return new ArrayList<ServerName>();
    }

    public void recommissionRegionServer(ServerName server, List<byte[]> encodedRegionNames) {
    }

    public List<TableCFs> listReplicatedTableCFs() {
        throw new UnsupportedOperationException("listReplicatedTableCFs not supported");
    }

    public void enableTableReplication(TableName tableName) {
        throw new UnsupportedOperationException("enableTableReplication not supported");
    }

    public void disableTableReplication(TableName tableName) {
        throw new UnsupportedOperationException("disableTableReplication not supported");
    }

    public void clearCompactionQueues(ServerName serverName, Set<String> queues) {
    }

    public List<ServerName> clearDeadServers(List<ServerName> servers) {
        return new ArrayList<ServerName>();
    }

    public void cloneTableSchema(TableName tableName, TableName newTableName, boolean preserveSplits) {
        throw new UnsupportedOperationException("cloneTableSchema not supported");
    }

    public Future<Void> createTableAsync(TableDescriptor desc) throws IOException {
        this.createTable(desc);
        return this.getVoidFuture();
    }

    public Future<Void> createTableAsync(TableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.createTable(desc, splitKeys);
        return this.getVoidFuture();
    }

    public Future<Void> deleteTableAsync(TableName tableName) throws IOException {
        this.deleteTable(tableName);
        return this.getVoidFuture();
    }

    public Future<Void> truncateTableAsync(TableName tableName, boolean preserveSplits) throws IOException {
        this.truncateTable(tableName, preserveSplits);
        return this.getVoidFuture();
    }

    public Future<Void> enableTableAsync(TableName tableName) throws IOException {
        this.enableTable(tableName);
        return this.getVoidFuture();
    }

    public Future<Void> disableTableAsync(TableName tableName) throws IOException {
        this.disableTable(tableName);
        return this.getVoidFuture();
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) {
        return new Pair((Object)0, (Object)1);
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) {
        return new Pair((Object)0, (Object)1);
    }

    public Future<Void> deleteColumnFamilyAsync(TableName tableName, byte[] columnFamily) throws IOException {
        this.deleteColumnFamily(tableName, columnFamily);
        return this.getVoidFuture();
    }

    public Future<Void> addColumnFamilyAsync(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        this.addColumnFamily(tableName, columnFamily);
        return this.getVoidFuture();
    }

    public Future<Void> modifyColumnFamilyAsync(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        this.modifyColumnFamily(tableName, columnFamily);
        return this.getVoidFuture();
    }

    public Future<Void> deleteNamespaceAsync(String name) throws IOException {
        this.deleteNamespace(name);
        return this.getVoidFuture();
    }

    public Map<TableName, Long> getSpaceQuotaTableSizes() throws IOException {
        throw new UnsupportedOperationException("getSpaceQuotaTableSizes not supported");
    }

    public Map<TableName, SpaceQuotaSnapshot> getRegionServerSpaceQuotaSnapshots(ServerName serverName) throws IOException {
        throw new UnsupportedOperationException("getRegionServerSpaceQuotaSnapshots not supported");
    }

    public SpaceQuotaSnapshot getCurrentSpaceQuotaSnapshot(String namespace) throws IOException {
        throw new UnsupportedOperationException("getCurrentSpaceQuotaSnapshot not supported");
    }

    public SpaceQuotaSnapshot getCurrentSpaceQuotaSnapshot(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("getCurrentSpaceQuotaSnapshot not supported");
    }

    public void grant(UserPermission userPermission, boolean mergeExistingPermissions) {
    }

    public void revoke(UserPermission userPermission) {
    }

    public Future<Void> splitRegionAsync(byte[] regionName) throws IOException {
        return this.splitRegionAsync(regionName, null);
    }

    public void move(byte[] bytes, byte[] bytes1) throws IOException {
    }

    public void splitRegionSync(byte[] regionName, byte[] splitPoint) throws IOException {
        this.splitRegion(regionName, splitPoint);
    }

    public void splitRegionSync(byte[] regionName, byte[] splitPoint, long timeout, TimeUnit units) throws IOException {
        this.splitRegionSync(regionName, splitPoint);
    }

    public byte[][] rollHLogWriter(String serverName) {
        return null;
    }

    public void mergeRegionsSync(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) throws IOException {
        this.mergeRegions(nameOfRegionA, nameOfRegionB, forcible);
    }

    Future<Void> splitRegionAsync(RegionInfo hri, byte[] splitPoint) throws IOException {
        this.splitRegion(hri.getRegionName(), splitPoint);
        return this.getVoidFuture();
    }

    Pair<RegionInfo, ServerName> getRegion(byte[] regionName) throws IOException {
        return new Pair();
    }

    @Override
    public List<AliHBaseIndexDescriptor> describeIndex(TableName dataTableName) throws IOException {
        return this.proxy.describeIndex(dataTableName);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor) throws IOException {
        this.proxy.createIndex(indexDescriptor);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[][] splitKeys) throws IOException {
        this.proxy.createIndex(indexDescriptor, splitKeys);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor index, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        this.proxy.createIndex(index, startKey, endKey, numRegions);
    }

    @Override
    public void deleteIndex(String indexName, TableName dataTable) throws IOException {
        this.proxy.deleteIndex(indexName, dataTable);
    }

    @Override
    public void offlineIndex(String indexName, TableName dataTable) throws IOException {
        this.proxy.offlineIndex(indexName, dataTable);
    }

    @Override
    public void registerBDSCluster(String hbaseSourceName, String bdsClusterkey, String hbaseConnectionString, String username, String password) throws IOException {
        this.proxy.registerBDSCluster(hbaseSourceName, bdsClusterkey, hbaseConnectionString, username, password);
    }

    @Override
    public void registerSolrCluster(String solrSourceName, String solrConnectionStr) throws IOException {
        this.proxy.registerSolrCluster(solrSourceName, solrConnectionStr);
    }

    @Override
    public void registerESCluster(String esSourceName, String esConnectionStr, String userName, String password) throws IOException {
        this.proxy.registerESCluster(esSourceName, esConnectionStr, userName, password);
    }

    @Override
    public void unregisterSolrCluster(boolean force) throws IOException {
        this.proxy.unregisterSolrCluster(force);
    }

    @Override
    public void unregisterESCluster(boolean force) throws IOException {
        this.proxy.unregisterESCluster(force);
    }

    @Override
    public void unregisterBDSCluster(boolean force) throws IOException {
        this.proxy.unregisterBDSCluster(force);
    }

    private Future<Void> getVoidFuture() {
        return new Future<Void>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return null;
            }
        };
    }
}

