/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.dml;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Row
extends VersionedObjectWithAttributes
implements Cloneable {
    private List<ColumnValue> columnValues;
    private Map<ColumnKey, List<ColumnValue>> valueMap = null;
    private List<ColumnKey> orderedColumns = null;
    private List<ColumnValue> orderedColumnValues = null;

    public Row() {
        this.columnValues = CollectionUtils.newArrayList();
    }

    public Row(int capacity) {
        this.columnValues = CollectionUtils.newArrayListWithCapacity(capacity);
    }

    public Row(List<ColumnValue> values) {
        this.setColumnValues(values);
    }

    public Row(ColumnValue ... values) {
        this.setColumnValues(values);
    }

    public Row add(ColumnValue columnValue) {
        this.columnValues.add(columnValue);
        return this;
    }

    public Row add(byte[] columnName, Object value) throws LindormException {
        this.columnValues.add(new ColumnValue(columnName, value));
        return this;
    }

    public Row add(String columnName, Object value) throws LindormException {
        this.columnValues.add(new ColumnValue(columnName, value));
        return this;
    }

    public Row add(byte[] familyName, byte[] columnName, Object value) throws LindormException {
        this.columnValues.add(new ColumnValue(familyName, columnName, value));
        return this;
    }

    public Row add(String familyName, String columnName, Object value) throws LindormException {
        this.columnValues.add(new ColumnValue(familyName, columnName, value));
        return this;
    }

    public List<ColumnValue> getColumnValues() {
        return this.columnValues;
    }

    public List<ColumnValue> getOrderedColumnValues() {
        if (this.orderedColumns == null) {
            throw new RuntimeException("Ordered ColumnKeys not set properly, clients can only call this method against Rows retrieved from SELECT statement.");
        }
        if (this.orderedColumnValues == null) {
            this.orderedColumnValues = CollectionUtils.newArrayListWithCapacity(this.columnValues.size());
            for (ColumnKey ck : this.orderedColumns) {
                this.orderedColumnValues.add(this.getColumnValue(ck));
            }
        }
        return this.orderedColumnValues;
    }

    public void setColumnValues(List<ColumnValue> values) {
        this.columnValues = values;
    }

    public void setColumnValues(ColumnValue ... values) {
        this.columnValues = CollectionUtils.newArrayListWithCapacity(values.length);
        for (ColumnValue cv : values) {
            this.columnValues.add(cv);
        }
    }

    public ColumnValue getColumnValue(byte[] columnName) {
        return this.getColumnValue(null, columnName);
    }

    public List<ColumnValue> getColumnValues(byte[] columnName) {
        return this.getColumnValues(null, columnName);
    }

    public ColumnValue getColumnValue(String columnName) {
        return this.getColumnValue(null, Bytes.toBytes(columnName));
    }

    public List<ColumnValue> getColumnValues(String columnName) {
        return this.getColumnValues(null, Bytes.toBytes(columnName));
    }

    public ColumnValue getColumnValue(byte[] familyName, byte[] columnName) {
        return this.getColumnValue(new ColumnKey(familyName, columnName));
    }

    public List<ColumnValue> getColumnValues(byte[] familyName, byte[] columnName) {
        return this.getColumnValues(new ColumnKey(familyName, columnName));
    }

    public ColumnValue getColumnValue(String familyName, String columnName) {
        return this.getColumnValue(new ColumnKey(Bytes.toBytes(familyName), Bytes.toBytes(columnName)));
    }

    public List<ColumnValue> getColumnValues(String familyName, String columnName) {
        return this.getColumnValues(new ColumnKey(Bytes.toBytes(familyName), Bytes.toBytes(columnName)));
    }

    public ColumnValue getColumnValue(ColumnKey key) {
        byte[] familyBytes;
        List<ColumnValue> values;
        ColumnValue value;
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.valueMap == null) {
            this.generateColumnValueMap();
        }
        ColumnValue columnValue = value = (values = this.valueMap.get(key)) != null ? values.get(0) : null;
        if (value == null && SchemaUtils.isDefaultFamily(familyBytes = key.getFamily())) {
            ColumnKey defaultFamilyKey = new ColumnKey(key.getQualifier());
            List<ColumnValue> valuesWithDefaultFamily = this.valueMap.get(defaultFamilyKey);
            value = valuesWithDefaultFamily != null ? valuesWithDefaultFamily.get(0) : null;
        }
        return value;
    }

    public List<ColumnValue> getColumnValues(ColumnKey key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.valueMap == null) {
            this.generateColumnValueMap();
        }
        return this.valueMap.get(key);
    }

    public int getEstimatedSize() {
        int size = 0;
        for (ColumnValue cv : this.columnValues) {
            size += cv.getEstimatedSize();
        }
        return size += 4;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        ret.append(this.columnValues.size());
        ret.append(": ");
        for (ColumnValue v : this.columnValues) {
            ret.append(v.toString());
            ret.append(",");
        }
        if (this.columnValues.size() > 0) {
            ret.setLength(ret.length() - 1);
        }
        ret.append("]");
        return ret.toString();
    }

    public String toStringLimited() {
        StringBuilder ret = new StringBuilder(1024);
        ret.append("[");
        ret.append(this.columnValues.size());
        ret.append(": ");
        for (ColumnValue v : this.columnValues) {
            ret.append(v.toString());
            ret.append(",");
            if (ret.length() < 1024) continue;
            ret.setLength(1020);
            ret.append("...]");
            return ret.toString();
        }
        if (this.columnValues.size() > 0) {
            ret.setLength(ret.length() - 1);
        }
        ret.append("]");
        return ret.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Row)) {
            return false;
        }
        Row other = (Row)obj;
        return this.columnValues.equals(other.columnValues);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.columnValues.size());
        for (ColumnValue columnValue : this.columnValues) {
            columnValue.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int numberOfColumns = WritableUtils.readVInt(in);
        this.columnValues = CollectionUtils.newArrayListWithCapacity(numberOfColumns);
        for (int i = 0; i < numberOfColumns; ++i) {
            ColumnValue c = new ColumnValue();
            c.readFrom(in);
            this.columnValues.add(c);
        }
    }

    public Row clone() throws CloneNotSupportedException {
        Row copy = (Row)super.clone();
        copy.valueMap = null;
        copy.orderedColumnValues = null;
        copy.columnValues.clear();
        for (ColumnValue col : this.columnValues) {
            copy.add(col.clone());
        }
        return copy;
    }

    public static String toString(List<Row> rows) {
        StringBuilder str = new StringBuilder();
        for (Row r : rows) {
            str.append(r.toString());
            str.append("\n");
        }
        return str.toString();
    }

    private void generateColumnValueMap() {
        this.valueMap = CollectionUtils.newHashMapWithExpectedSize(this.columnValues.size());
        for (ColumnValue cv : this.columnValues) {
            List<ColumnValue> values = this.valueMap.get(cv.getColumnKey());
            if (values == null) {
                values = new ArrayList<ColumnValue>();
                this.valueMap.put(cv.getColumnKey(), values);
            }
            values.add(cv);
        }
    }

    public void setOrderedColumns(List<ColumnKey> orderedColumns) {
        this.orderedColumns = orderedColumns;
    }
}

