/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WPageFilter
extends WFilter {
    protected long pageSize = Long.MAX_VALUE;

    public WPageFilter() {
    }

    public WPageFilter(long pageSize) {
        Preconditions.checkArgument(pageSize >= 0L, "must be positive %s", pageSize);
        this.pageSize = pageSize;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVLong(out, this.pageSize);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.pageSize = WritableUtils.readVLong(in);
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WPageFilter;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.pageSize;
    }
}

