/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WMultiRowRangeFilter
extends WFilter {
    private List<WRowRange> rangeList;

    public WMultiRowRangeFilter() {
    }

    public WMultiRowRangeFilter(List<WRowRange> list) {
        this.rangeList = list;
    }

    public List<WRowRange> getRangeList() {
        return this.rangeList;
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WMultiRowRangeFilter;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.rangeList.size());
        for (WRowRange range : this.rangeList) {
            range.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int size = in.readInt();
        this.rangeList = new ArrayList<WRowRange>();
        for (int i = 0; i < size; ++i) {
            WRowRange rowRange = new WRowRange();
            rowRange.readFrom(in);
            this.rangeList.add(rowRange);
        }
    }

    public static class WRowRange
    extends VersionedObjectWithAttributes {
        private byte[] startRow;
        private boolean startRowInclusive = true;
        private byte[] stopRow;
        private boolean stopRowInclusive = false;

        public WRowRange() {
        }

        public WRowRange(String startRow, boolean startRowInclusive, String stopRow, boolean stopRowInclusive) {
            this(startRow == null || startRow.isEmpty() ? LindormClientConstants.EMPTY_BYTE_ARRAY : Bytes.toBytes(startRow), startRowInclusive, stopRow == null || stopRow.isEmpty() ? LindormClientConstants.EMPTY_BYTE_ARRAY : Bytes.toBytes(stopRow), stopRowInclusive);
        }

        public WRowRange(byte[] startRow, boolean startRowInclusive, byte[] stopRow, boolean stopRowInclusive) {
            this.startRow = startRow == null ? LindormClientConstants.EMPTY_BYTE_ARRAY : startRow;
            this.startRowInclusive = startRowInclusive;
            this.stopRow = stopRow == null ? LindormClientConstants.EMPTY_BYTE_ARRAY : stopRow;
            this.stopRowInclusive = stopRowInclusive;
        }

        public byte[] getStartRow() {
            return this.startRow;
        }

        public boolean isStartRowInclusive() {
            return this.startRowInclusive;
        }

        public byte[] getStopRow() {
            return this.stopRow;
        }

        public boolean isStopRowInclusive() {
            return this.stopRowInclusive;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Bytes.writeByteArray(out, this.startRow);
            out.writeBoolean(this.startRowInclusive);
            Bytes.writeByteArray(out, this.stopRow);
            out.writeBoolean(this.stopRowInclusive);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            super.readFrom(in);
            this.startRow = Bytes.readByteArray(in);
            this.startRowInclusive = in.readBoolean();
            this.stopRow = Bytes.readByteArray(in);
            this.stopRowInclusive = in.readBoolean();
        }
    }
}

