/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.ipc.LindormObject;
import com.alibaba.lindorm.client.core.ipc.Serializer;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.ReflectionUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WExecResult
extends VersionedObjectWithAttributes {
    private byte[] regionName;
    private Object value;
    private LindormClientConfig config = new LindormClientConfig();

    public WExecResult() {
    }

    public WExecResult(Object value) {
        this(LindormClientConstants.EMPTY_BYTE_ARRAY, value);
    }

    public WExecResult(byte[] region, Object value) {
        this.regionName = region;
        this.value = value;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        Serializer serializer = this.getSerializer();
        super.writeTo(out);
        Bytes.writeByteArray(out, this.regionName);
        serializer.serialize(out, this.value, this.value != null ? this.value.getClass() : LindormObject.class);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        Serializer serializer = this.getSerializer();
        super.readFrom(in);
        this.regionName = Bytes.readByteArray(in);
        this.value = serializer.deserialize(in);
    }

    private Serializer getSerializer() {
        Class<?> serializerClass = this.config.getClass("lindorm.rpc.serializer.class", "com.alibaba.lindorm.server.client.WritableSerializer", LindormClientConstants.RPC_SERIALIZER_CLASS_DEFAULT);
        Serializer serializer = (Serializer)ReflectionUtils.newInstance(serializerClass);
        return serializer;
    }
}

