/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.ipc.LindormObject;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataInputBuffer;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LindormObjectUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(LindormObject lindormObject) throws IOException {
        if (lindormObject == null) {
            throw new IllegalArgumentException("Writable cannot be null");
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            lindormObject.writeTo(out);
            out.close();
            out = null;
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static LindormObject getWritable(byte[] bytes, LindormObject lindormObject) throws IOException {
        return LindormObjectUtils.getWritable(bytes, 0, bytes.length, lindormObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LindormObject getWritable(byte[] bytes, int offset, int length, LindormObject lindormObject) throws IOException {
        if (bytes == null || length <= 0) {
            throw new IllegalArgumentException("Can't build a writable with empty bytes array");
        }
        if (lindormObject == null) {
            throw new IllegalArgumentException("Writable cannot be null");
        }
        DataInputBuffer in = new DataInputBuffer();
        try {
            in.reset(bytes, offset, length);
            lindormObject.readFrom(in);
            LindormObject lindormObject2 = lindormObject;
            return lindormObject2;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] byteArraysToBytes(List<byte[]> byteArrays) throws IOException {
        if (byteArrays == null || byteArrays.size() == 0) {
            throw new IllegalArgumentException("byteArrays must not be null or empty.");
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            WritableUtils.writeVInt(out, byteArrays.size());
            for (byte[] bytes : byteArrays) {
                Bytes.writeByteArray(out, bytes);
            }
            out.close();
            out = null;
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<byte[]> byteArraysFromBytes(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length <= 0) {
            throw new IllegalArgumentException("Input bytes must not be null or empty");
        }
        DataInputBuffer in = new DataInputBuffer();
        try {
            in.reset(bytes, 0, bytes.length);
            int numberOfArrays = WritableUtils.readVInt(in);
            ArrayList<byte[]> ret = new ArrayList<byte[]>(numberOfArrays);
            for (int i = 0; i < numberOfArrays; ++i) {
                byte[] b = Bytes.readByteArray(in);
                ret.add(b);
            }
            ArrayList<byte[]> arrayList = ret;
            return arrayList;
        }
        finally {
            in.close();
        }
    }
}

