/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.MsgDigestWrapper;
import java.security.NoSuchAlgorithmException;
import java.util.EnumMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class KeyHashFunction {
    static final Log LOG = LogFactory.getLog(KeyHashFunction.class);
    private static ThreadLocal<EnumMap<HashType, MsgDigestWrapper>> instance = new ThreadLocal<EnumMap<HashType, MsgDigestWrapper>>(){

        @Override
        protected EnumMap<HashType, MsgDigestWrapper> initialValue() {
            return new EnumMap<HashType, MsgDigestWrapper>(HashType.class);
        }
    };
    public static final int HASHKEY_LENGTH = 8;

    public static KeyHashFunction getHashFunction(HashType type) {
        EnumMap<HashType, MsgDigestWrapper> map = instance.get();
        MsgDigestWrapper func = map.get((Object)type);
        if (func == null) {
            try {
                func = new MsgDigestWrapper(type.toString());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            map.put(type, func);
        }
        return func;
    }

    public static KeyHashFunction getHashFunction() {
        return KeyHashFunction.getHashFunction(HashType.SHA1);
    }

    public static byte[] computeHashKeyFromRow(byte[] rowArray, int rowOffset, int rowLen) {
        KeyHashFunction hashFunction = KeyHashFunction.getHashFunction();
        return hashFunction.computeHash(rowArray, rowOffset, rowLen);
    }

    public static byte[][] evenSplit(int numRegions) {
        if (numRegions <= 1) {
            return new byte[0][];
        }
        byte[][] ret = new byte[numRegions - 1][];
        int width = Bytes.getPower(numRegions);
        for (int i = 1; i < numRegions; ++i) {
            long splitValue = (long)i << 64 - width;
            ret[i - 1] = Bytes.toBytes(splitValue);
        }
        return ret;
    }

    public abstract byte[] computeHash(byte[] var1, int var2, int var3);

    public static enum HashType {
        SHA1("SHA-1");

        private final String name;

        private HashType(String n2) {
            this.name = n2;
        }

        public String toString() {
            return this.name;
        }
    }
}

