/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.compile.ColumnSlot;
import com.alibaba.lindorm.client.core.compile.ConjunctiveClause;
import com.alibaba.lindorm.client.core.compile.DNFCompiler;
import com.alibaba.lindorm.client.core.compile.DisjunctiveNormalForm;
import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.compile.IntervalQuery;
import com.alibaba.lindorm.client.core.compile.PrefixQuery;
import com.alibaba.lindorm.client.core.compile.QueryFilterInfo;
import com.alibaba.lindorm.client.core.compile.TransformIntoDNFVisitor;
import com.alibaba.lindorm.client.core.compile.WhereCompiler;
import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.IndexUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.dml.OrderedColumnKey;
import com.alibaba.lindorm.client.exception.ColumnNotFoundException;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class CompilerUtils {
    private static final LDataTypeFactory TYPE_FACTORY = LDataTypeFactory.INSTANCE;

    public static ConditionFactory.CompareOp transformCompareOp(SortOrder sortOrder, ConditionFactory.CompareOp originOp) {
        if (sortOrder == SortOrder.ASC) {
            return originOp;
        }
        switch (originOp) {
            case LESS: {
                return ConditionFactory.CompareOp.GREATER;
            }
            case LESS_OR_EQUAL: {
                return ConditionFactory.CompareOp.GREATER_OR_EQUAL;
            }
            case EQUAL: {
                return originOp;
            }
            case NOT_EQUAL: {
                return originOp;
            }
            case GREATER_OR_EQUAL: {
                return ConditionFactory.CompareOp.LESS_OR_EQUAL;
            }
            case GREATER: {
                return ConditionFactory.CompareOp.LESS;
            }
            case IS: {
                return ConditionFactory.CompareOp.IS;
            }
            case IS_NOT: {
                return ConditionFactory.CompareOp.IS_NOT;
            }
        }
        throw new IllegalArgumentException("Unknown compare op " + (Object)((Object)originOp));
    }

    public static boolean compare(ConditionFactory.CompareOp op, int compareResult, boolean isNullValue) {
        switch (op) {
            case LESS: {
                return compareResult < 0 && !isNullValue;
            }
            case LESS_OR_EQUAL: {
                return compareResult <= 0 && !isNullValue;
            }
            case EQUAL: {
                return compareResult == 0 && !isNullValue;
            }
            case IS: {
                return compareResult == 0;
            }
            case NOT_EQUAL: {
                return compareResult != 0 && !isNullValue;
            }
            case IS_NOT: {
                return compareResult != 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult >= 0 && !isNullValue;
            }
            case GREATER: {
                return compareResult > 0 && !isNullValue;
            }
        }
        throw new RuntimeException("Unknown Compare op " + op.name());
    }

    public static Interval getKeyInterval(LColumn column, ComparisonExpression expr) throws LindormException {
        LDataType metaType = column.getDataType();
        byte[] key = expr.evaluateRHS(column);
        ConditionFactory.CompareOp op = CompilerUtils.transformCompareOp(column.getSortOrder(), expr.getOp());
        switch (op) {
            case EQUAL: {
                return metaType.getKeyInterval(key, true, key, true);
            }
            case GREATER_OR_EQUAL: {
                return metaType.getKeyInterval(key, true, Interval.UNBOUND, false);
            }
            case GREATER: {
                return metaType.getKeyInterval(key, false, Interval.UNBOUND, false);
            }
            case LESS: {
                return metaType.getKeyInterval(Interval.UNBOUND, false, key, false);
            }
            case LESS_OR_EQUAL: {
                return metaType.getKeyInterval(Interval.UNBOUND, false, key, true);
            }
            case NOT_EQUAL: {
                throw new IllegalArgumentException("Please call getKeyIntervalForNotEqual for NOT_EQUAL operator.");
            }
        }
        throw new IllegalArgumentException("Unknown compare operator " + (Object)((Object)expr.getOp()));
    }

    public static List<Interval> getKeyIntervalForNotEqual(LColumn column, ComparisonExpression expr) throws LindormException {
        byte[] key = expr.evaluateRHS(column);
        if (expr.getOp() == ConditionFactory.CompareOp.NOT_EQUAL) {
            ArrayList<Interval> ret = CollectionUtils.newArrayListWithCapacity(2);
            ret.add(Interval.create(Interval.UNBOUND, false, key, false));
            ret.add(Interval.create(key, false, Interval.UNBOUND, false));
            return ret;
        }
        throw new IllegalArgumentException("Please call getKeyInterval for operator " + (Object)((Object)expr.getOp()));
    }

    public static byte[] getRowKeyForRouting(TableMeta table, Condition where) throws LindormException {
        assert (table != null);
        byte[] rowKey = null;
        DisjunctiveNormalForm dnf = CompilerUtils.transformIntoDNF(table, where);
        DNFCompiler dnfCompiler = new DNFCompiler(table, dnf);
        Object intervalQueries = dnfCompiler.compile();
        if (intervalQueries != null && !intervalQueries.isEmpty()) {
            rowKey = ((IntervalQuery)intervalQueries.get(0)).getInterval().getLower();
        }
        return rowKey;
    }

    public static byte[] getMinKey(WhereCompiler.SingleIntervalKeySlot[] slots) throws LindormException {
        int length = 0;
        Interval[] ranges = new Interval[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            Interval range;
            WhereCompiler.SingleIntervalKeySlot slot = slots[i];
            ranges[i] = range = slot.interval;
            if (!range.isSingleValue() && i != slots.length - 1) {
                throw new LindormException("Only the last pk column in WHERE clause can be a range");
            }
            length += range.getLower().length;
        }
        Interval lastInterval = ranges[ranges.length - 1];
        DataType lastSlotDataType = slots[ranges.length - 1].column.getDataType().getClientType();
        if (!lastInterval.isLowerInclusive() && DataType.VARBINARY == lastSlotDataType) {
            ++length;
        }
        byte[] key = new byte[length];
        int offset = 0;
        for (Interval range : ranges) {
            if (range.isLowerUnbound()) break;
            int keyLength = range.getLower().length;
            System.arraycopy(range.getLower(), 0, key, offset, keyLength);
            if (!range.isLowerInclusive()) {
                if (DataType.VARBINARY == lastSlotDataType) {
                    CompilerUtils.nextVarBinaryKey(key, offset, keyLength);
                    ++keyLength;
                } else {
                    CompilerUtils.nextKey(key, offset, keyLength);
                }
            }
            offset += keyLength;
        }
        if (offset == length) {
            return key;
        }
        byte[] copy = new byte[offset];
        System.arraycopy(key, 0, copy, 0, offset);
        return copy;
    }

    public static byte[] getMaxKey(WhereCompiler.SingleIntervalKeySlot[] slots) throws LindormException {
        int length = 0;
        Interval[] ranges = new Interval[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            Interval range;
            WhereCompiler.SingleIntervalKeySlot slot = slots[i];
            ranges[i] = range = slot.interval;
            if (!range.isSingleValue() && i != slots.length - 1) {
                throw new LindormException("Only the last pk column in WHERE clause can be a range");
            }
            length += range.getUpper().length;
        }
        Interval lastInterval = ranges[ranges.length - 1];
        DataType lastSlotDataType = slots[ranges.length - 1].column.getDataType().getClientType();
        if (lastInterval.isUpperInclusive() && DataType.VARBINARY.equals((Object)lastSlotDataType)) {
            ++length;
        }
        byte[] key = new byte[length];
        int offset = 0;
        for (int i = 0; i < slots.length; ++i) {
            Interval range = ranges[i];
            if (range.isUpperUnbound()) {
                if (i != slots.length - 1) break;
                CompilerUtils.nextKey(key, 0, offset);
                break;
            }
            System.arraycopy(range.getUpper(), 0, key, offset, range.getUpper().length);
            int keyLength = range.getUpper().length;
            if (range.isUpperInclusive() && i == slots.length - 1) {
                if (DataType.VARBINARY.equals((Object)lastSlotDataType)) {
                    CompilerUtils.nextVarBinaryKey(key, offset, keyLength);
                    ++keyLength;
                } else {
                    CompilerUtils.nextKey(key, offset, keyLength);
                }
            }
            offset += keyLength;
        }
        if (offset == length) {
            return key;
        }
        byte[] copy = new byte[offset];
        System.arraycopy(key, 0, copy, 0, offset);
        return copy;
    }

    public static byte[] nextKey(byte[] key) {
        byte[] ret = new byte[key.length];
        System.arraycopy(key, 0, ret, 0, key.length);
        if (!CompilerUtils.nextKey(ret, 0, ret.length)) {
            return null;
        }
        return ret;
    }

    public static boolean nextKey(byte[] key, int offset, int length) {
        if (length == 0) {
            return false;
        }
        int i = offset + length - 1;
        while (key[i] == -1) {
            key[i] = 0;
            if (--i >= offset) continue;
            do {
                key[++i] = -1;
            } while (i < offset + length - 1);
            return false;
        }
        key[i] = (byte)(key[i] + 1);
        return true;
    }

    public static boolean nextVarBinaryKey(byte[] key, int offset, int length) {
        if (length == 0) {
            return false;
        }
        key[offset + length] = 0;
        return true;
    }

    public static byte[] concatRowKey(byte[][] bytes, int totalLength) {
        byte[] ret = new byte[totalLength];
        int offset = 0;
        for (byte[] v : bytes) {
            if (v == null) break;
            System.arraycopy(v, 0, ret, offset, v.length);
            offset += v.length;
        }
        return ret;
    }

    public static byte[] concatRowKey(byte[] ... bytes) {
        int totalLength = 0;
        for (byte[] part : bytes) {
            totalLength += part.length;
        }
        byte[] ret = new byte[totalLength];
        int offset = 0;
        for (byte[] v : bytes) {
            System.arraycopy(v, 0, ret, offset, v.length);
            offset += v.length;
        }
        return ret;
    }

    public static byte[] concatRowKey(ImmutableBytesPtr[] bytes, int totalLength) {
        byte[] ret = new byte[totalLength];
        int offset = 0;
        for (ImmutableBytesPtr v : bytes) {
            if (v == null) break;
            System.arraycopy(v.get(), v.getOffset(), ret, offset, v.getLength());
            offset += v.getLength();
        }
        return ret;
    }

    public static byte[] concatRowKey(byte[][] bytes, int totalLength, List<LColumn> pkSchema) throws IllegalDataException {
        byte[] ret = new byte[totalLength];
        int offset = 0;
        for (int i = 0; i < pkSchema.size(); ++i) {
            byte[] v = bytes[i];
            if (v == null) {
                throw new IllegalDataException("Not enough PK column values in UPSERT, [" + pkSchema.get(i).toString() + "] is missing.");
            }
            System.arraycopy(v, 0, ret, offset, v.length);
            offset += v.length;
        }
        return ret;
    }

    public static DisjunctiveNormalForm transformIntoDNF(TableMeta table, Condition condition) throws LindormException {
        if (condition == null) {
            return null;
        }
        TransformIntoDNFVisitor visitor = new TransformIntoDNFVisitor(table);
        return condition.accept(visitor);
    }

    public static PrefixQuery generatePrefixQuery(TableMeta table, List<ColumnSlot> columnSlots, List<ColumnSlot> consecutivePKColumns) {
        boolean isPointLookUp;
        int numConsecutivePKColumns = consecutivePKColumns.size();
        boolean bl = isPointLookUp = numConsecutivePKColumns == table.getPkColumns().size();
        if (numConsecutivePKColumns >= columnSlots.size()) {
            return new PrefixQuery(CompilerUtils.createRowKeyRange(consecutivePKColumns, isPointLookUp), null);
        }
        ColumnSlot lastColumnSlot = columnSlots.get(numConsecutivePKColumns);
        LColumn lastColumn = lastColumnSlot.getColumn();
        if (!lastColumn.isPrimaryKey() || lastColumn.getPosition() != numConsecutivePKColumns) {
            return new PrefixQuery(CompilerUtils.createRowKeyRange(consecutivePKColumns, isPointLookUp), QueryFilterInfo.create(columnSlots, numConsecutivePKColumns));
        }
        return new PrefixQuery(CompilerUtils.createRowKeyRange(consecutivePKColumns, lastColumnSlot), QueryFilterInfo.create(columnSlots, !lastColumnSlot.hasSimilarities() ? numConsecutivePKColumns + 1 : numConsecutivePKColumns));
    }

    private static List<Interval> createRowKeyRange(List<ColumnSlot> consecutivePKColumns, boolean isPointLookUp) {
        if (isPointLookUp) {
            return Collections.singletonList(Interval.create(CompilerUtils.createRowKey(consecutivePKColumns)));
        }
        if (consecutivePKColumns.isEmpty()) {
            return Collections.singletonList(Interval.EVERYTHING_RANGE);
        }
        int numConsecutivePKColumns = consecutivePKColumns.size();
        byte[][] values = new byte[numConsecutivePKColumns][];
        for (int i = 0; i < numConsecutivePKColumns; ++i) {
            values[i] = consecutivePKColumns.get(i).getInterval().getLower();
        }
        byte[] lower = CompilerUtils.concatRowKey((byte[][])values);
        int lastConsecutivePKColumnIndex = numConsecutivePKColumns - 1;
        byte[] lastValue = consecutivePKColumns.get(lastConsecutivePKColumnIndex).getInterval().getLower();
        values[lastConsecutivePKColumnIndex] = lastValue;
        byte[] upper = CompilerUtils.createNextRowKey(values, consecutivePKColumns);
        return Collections.singletonList(Interval.create(lower, upper));
    }

    private static byte[] createRowKey(List<ColumnSlot> consecutivePKColumns) {
        byte[][] values = new byte[consecutivePKColumns.size()][];
        int keyLength = 0;
        for (int i = 0; i < consecutivePKColumns.size(); ++i) {
            values[i] = consecutivePKColumns.get(i).getInterval().getLower();
            keyLength += values[i].length;
        }
        return CompilerUtils.concatRowKey((byte[][])values, keyLength);
    }

    private static byte[] createNextRowKey(byte[][] values, List<ColumnSlot> consecutivePKColumns) {
        for (int i = consecutivePKColumns.size() - 1; i >= 0; --i) {
            LColumn column = consecutivePKColumns.get(i).getColumn();
            byte[] next = CompilerUtils.getNextValue(column, values[i]);
            if (next == null) continue;
            return CompilerUtils.concatRowKey(values, 0, i - 1, next);
        }
        return Interval.UNBOUND;
    }

    private static byte[] getNextValue(LColumn column, byte[] value) {
        if (Bytes.compareTo(value, Interval.UNBOUND) == 0) {
            return null;
        }
        boolean isVarBinary = DataType.VARBINARY.equals((Object)column.getDataType().getClientType());
        int length = isVarBinary ? value.length + 1 : value.length;
        byte[] next = new byte[length];
        System.arraycopy(value, 0, next, 0, value.length);
        if (isVarBinary) {
            return (byte[])(CompilerUtils.nextVarBinaryKey(next, 0, value.length) ? next : null);
        }
        return (byte[])(CompilerUtils.nextKey(next, 0, length) ? next : null);
    }

    private static byte[] concatRowKey(byte[][] values, int fromIndex, int toIndex, byte[] lastValue) {
        int offset = 0;
        int totalLength = 0;
        for (int i = fromIndex; i <= toIndex; ++i) {
            totalLength += values[i].length;
        }
        byte[] ret = new byte[totalLength += lastValue.length];
        for (int i = fromIndex; i <= toIndex; ++i) {
            System.arraycopy(values[i], 0, ret, offset, values[i].length);
            offset += values[i].length;
        }
        System.arraycopy(lastValue, 0, ret, offset, lastValue.length);
        return ret;
    }

    private static List<Interval> createRowKeyRange(List<ColumnSlot> consecutivePKColumns, ColumnSlot lastColumnSlot) {
        int numConsecutivePKColumns = consecutivePKColumns.size();
        byte[][] values = new byte[numConsecutivePKColumns + 1][];
        for (int i = 0; i < numConsecutivePKColumns; ++i) {
            values[i] = consecutivePKColumns.get(i).getInterval().getLower();
        }
        LColumn column = lastColumnSlot.getColumn();
        Interval interval = lastColumnSlot.getInterval();
        SortedSet<ColumnSlot.Point> points = lastColumnSlot.getExclusions();
        ArrayList<Interval> intervals = new ArrayList<Interval>(1 + (points == null ? 0 : points.size()));
        byte[] lower = CompilerUtils.createRowKeyForLower(values, consecutivePKColumns, column, interval);
        if (!interval.isLowerUnbound() && Bytes.compareTo(lower, Interval.UNBOUND) == 0) {
            return intervals;
        }
        if (points != null) {
            for (ColumnSlot.Point point : points) {
                values[numConsecutivePKColumns] = point.getValue();
                byte[] upper = CompilerUtils.concatRowKey((byte[][])values);
                CompilerUtils.addToIntervals(intervals, lower, upper);
                lower = CompilerUtils.createNextRowKey(values, consecutivePKColumns, column, point.getValue());
                if (Bytes.compareTo(lower, Interval.UNBOUND) != 0) continue;
                return intervals;
            }
        }
        byte[] upper = CompilerUtils.createRowKeyForUpper(values, consecutivePKColumns, column, interval);
        CompilerUtils.addToIntervals(intervals, lower, upper);
        return intervals;
    }

    private static byte[] createRowKeyForLower(byte[][] values, List<ColumnSlot> consecutivePKColumns, LColumn lastColumn, Interval lastInterval) {
        int lastIndex = values.length - 1;
        if (lastInterval.isLowerInclusive()) {
            values[lastIndex] = lastInterval.getLower();
            return CompilerUtils.concatRowKey(values);
        }
        if (lastInterval.isLowerUnbound()) {
            values[lastIndex] = SchemaUtils.storePkNulls(lastColumn) && lastColumn.getSortOrder() == SortOrder.ASC ? SchemaUtils.VALUE_PREFIX_BYTES : lastInterval.getLower();
            return CompilerUtils.concatRowKey(values);
        }
        return CompilerUtils.createNextRowKey(values, consecutivePKColumns, lastColumn, lastInterval.getLower());
    }

    private static byte[] createNextRowKey(byte[][] values, List<ColumnSlot> consecutivePKColumns, LColumn lastColumn, byte[] lastValue) {
        int lastIndex = values.length - 1;
        byte[] next = CompilerUtils.getNextValue(lastColumn, lastValue);
        if (next != null) {
            values[lastIndex] = next;
            return CompilerUtils.concatRowKey(values);
        }
        return CompilerUtils.createNextRowKey(values, consecutivePKColumns);
    }

    private static byte[] createRowKeyForUpper(byte[][] values, List<ColumnSlot> consecutivePKColumns, LColumn lastColumn, Interval lastInterval) {
        int lastIndex = values.length - 1;
        if (!lastInterval.isUpperInclusive() && !lastInterval.isUpperUnbound()) {
            values[lastIndex] = lastInterval.getUpper();
            return CompilerUtils.concatRowKey(values);
        }
        if (lastInterval.isUpperUnbound() && SchemaUtils.storePkNulls(lastColumn) && lastColumn.getSortOrder() == SortOrder.DESC) {
            values[lastIndex] = SchemaUtils.VALUE_PREFIX_BYTES;
            return CompilerUtils.concatRowKey(values);
        }
        return CompilerUtils.createNextRowKey(values, consecutivePKColumns, lastColumn, lastInterval.getUpper());
    }

    private static void addToIntervals(List<Interval> intervals, byte[] lower, byte[] upper) {
        Interval newInterval = Interval.create(lower, upper);
        if (!newInterval.equals(Interval.EMPTY_RANGE)) {
            intervals.add(newInterval);
        }
    }

    public static int compareColumnPosition(LColumn column, LColumn otherColumn) {
        int position = column.getPosition();
        int otherPosition = otherColumn.getPosition();
        if (position >= 0 && otherPosition >= 0) {
            return position == otherPosition ? 0 : (position > otherPosition ? 1 : -1);
        }
        if (position >= 0) {
            return -1;
        }
        if (otherPosition >= 0) {
            return 1;
        }
        byte[] columnFullName = column.getFullName();
        byte[] otherColumnFullName = otherColumn.getFullName();
        return Bytes.compareTo(columnFullName, otherColumnFullName);
    }

    public static DisjunctiveNormalForm rewriteDNF(TableMeta table, DisjunctiveNormalForm dnf) throws IllegalDataException {
        List<ConjunctiveClause> clauses = dnf.getConjunctiveClauses();
        ArrayList<ConjunctiveClause> newClauses = new ArrayList<ConjunctiveClause>(clauses.size());
        for (ConjunctiveClause clause : clauses) {
            List<ColumnSlot> columnSlots = clause.getColumnSlots();
            ArrayList<ColumnSlot> transformedColumnSlots = new ArrayList<ColumnSlot>(columnSlots.size());
            for (ColumnSlot columnSlot : columnSlots) {
                LColumn lColumn;
                ColumnKey columnKey = IndexUtils.getIndexColumnKey(columnSlot.getColumn().getColumnKey(), table);
                try {
                    lColumn = table.resolveColumn(columnKey);
                }
                catch (ColumnNotFoundException e) {
                    lColumn = columnSlot.getColumn().deepCopy(-1, false);
                }
                transformedColumnSlots.add(CompilerUtils.transformColumnSlot(columnSlot, lColumn));
            }
            Collections.sort(transformedColumnSlots, new Comparator<ColumnSlot>(){

                @Override
                public int compare(ColumnSlot slot, ColumnSlot otherSlot) {
                    return CompilerUtils.compareColumnPosition(slot.getColumn(), otherSlot.getColumn());
                }
            });
            newClauses.add(new ConjunctiveClause(transformedColumnSlots));
        }
        return new DisjunctiveNormalForm(newClauses);
    }

    private static ColumnSlot transformColumnSlot(ColumnSlot columnSlot, LColumn newLColumn) throws IllegalDataException {
        boolean sortOrderChanged;
        if (columnSlot.doesNotExist()) {
            return columnSlot;
        }
        LColumn oldLColumn = columnSlot.getColumn();
        Interval oldInterval = columnSlot.getInterval();
        Interval interval = null;
        SortedSet<ColumnSlot.Point> oldExclusions = columnSlot.getExclusions();
        SortedSet<ColumnSlot.Point> exclusions = null;
        boolean bl = sortOrderChanged = !newLColumn.getSortOrder().equals((Object)oldLColumn.getSortOrder());
        if (CompilerUtils.needTransformValue(oldLColumn, newLColumn)) {
            if (oldInterval != null) {
                byte[] lower = oldInterval.isLowerUnbound() ? oldInterval.getLower() : CompilerUtils.transformValue(oldInterval.getLower(), oldLColumn, newLColumn);
                byte[] upper = oldInterval.isUpperUnbound() ? oldInterval.getUpper() : CompilerUtils.transformValue(oldInterval.getUpper(), oldLColumn, newLColumn);
                interval = sortOrderChanged ? Interval.create(upper, oldInterval.isUpperInclusive(), lower, oldInterval.isLowerInclusive()) : Interval.create(lower, oldInterval.isLowerInclusive(), upper, oldInterval.isUpperInclusive());
                if (oldExclusions != null) {
                    exclusions = new TreeSet<ColumnSlot.Point>();
                    for (ColumnSlot.Point point : oldExclusions) {
                        exclusions.add(new ColumnSlot.Point(CompilerUtils.transformValue(point.getValue(), oldLColumn, newLColumn)));
                    }
                }
            } else {
                byte[] nullValueBytes = LDataType.toBytes(newLColumn, null, TYPE_FACTORY.getTypeInstance(newLColumn.getDataType().getClientType()));
                interval = Interval.create(nullValueBytes);
            }
        } else {
            interval = oldInterval;
            exclusions = oldExclusions;
        }
        return ColumnSlot.create(newLColumn, interval, exclusions, columnSlot.getSimilarities());
    }

    public static boolean needTransformValue(LColumn oldLColumn, LColumn newLColumn) {
        boolean changeDataType = !newLColumn.getDataType().equals(oldLColumn.getDataType());
        boolean storePkNulls = SchemaUtils.storePkNulls(newLColumn);
        boolean changeToPrimaryKey = newLColumn.isPrimaryKey() && !oldLColumn.isPrimaryKey();
        boolean sortOrderChanged = !newLColumn.getSortOrder().equals((Object)oldLColumn.getSortOrder());
        return changeDataType || changeToPrimaryKey || sortOrderChanged || storePkNulls;
    }

    private static byte[] transformValue(byte[] value, LColumn oldLColumn, LColumn newLColumn) throws IllegalDataException {
        Object object = LDataType.toObject(oldLColumn, value);
        DataType type = newLColumn.getDataType().getClientType();
        return LDataType.toBytes(newLColumn, object, LDataTypeFactory.INSTANCE.getTypeInstance(type));
    }

    public static Condition convertToExpression(DisjunctiveNormalForm dnf) throws IllegalDataException, IllegalRequestException {
        ConditionList orExpression = ConditionFactory.or();
        List<ConjunctiveClause> clauses = dnf.getConjunctiveClauses();
        for (ConjunctiveClause clause : clauses) {
            List<ColumnSlot> columnSlots = clause.getColumnSlots();
            if (columnSlots == null) continue;
            orExpression.add(CompilerUtils.convertToAndExpression(columnSlots));
        }
        return orExpression.getConditions().size() > 1 ? orExpression : orExpression.getConditions().get(0);
    }

    public static Condition convertToAndExpression(List<ColumnSlot> columnSlots) throws IllegalRequestException, IllegalDataException {
        if (columnSlots.size() == 1) {
            return columnSlots.get(0).toExpression();
        }
        ConditionList andExpression = ConditionFactory.and();
        for (ColumnSlot columnSlot : columnSlots) {
            andExpression.add(columnSlot.toExpression());
        }
        return andExpression;
    }

    public static DisjunctiveNormalForm convertToDNF(List<QueryFilterInfo> filters) {
        if (filters == null || filters.isEmpty()) {
            return new DisjunctiveNormalForm();
        }
        ArrayList<ConjunctiveClause> conjunctiveClauses = new ArrayList<ConjunctiveClause>(filters.size());
        for (QueryFilterInfo filter : filters) {
            List<ColumnSlot> columnSlots = filter.getColumnSlots();
            if (columnSlots == null || columnSlots.isEmpty()) continue;
            conjunctiveClauses.add(new ConjunctiveClause(columnSlots));
        }
        return new DisjunctiveNormalForm(conjunctiveClauses);
    }

    public static void throwIfHashScan(TableMeta table, LColumn column, ComparisonExpression node) throws LindormException {
        if (column.isHashed() && column.equals(table.getFirstPK()) && node.getOp() != ConditionFactory.CompareOp.EQUAL) {
            throw new LindormException("Do not support scan for hashed table, hashed primary key:" + column);
        }
    }

    public static QuerySortType getQuerySortType(TableMeta table, List<OrderedColumnKey> orderByColumns) throws LindormException {
        Integer lastPosition = null;
        QuerySortType sortType = null;
        for (OrderedColumnKey orderByColumn : orderByColumns) {
            try {
                ColumnKey columnKey = !table.isIndex() ? new ColumnKey(orderByColumn.getFamily(), orderByColumn.getQualifier()) : IndexUtils.getIndexColumnKey(orderByColumn, table);
                LColumn lColumn = table.resolveColumn(columnKey);
                if (!lColumn.isPrimaryKey() || lastPosition != null && lastPosition + 1 != lColumn.getPosition()) {
                    return QuerySortType.EXTRA;
                }
                lastPosition = lColumn.getPosition();
                boolean sortOrderMatched = lColumn.getSortOrder().equals((Object)orderByColumn.getSortOrder());
                if (sortType == null) {
                    sortType = sortOrderMatched ? QuerySortType.FORWARD : QuerySortType.REVERSE;
                    continue;
                }
                if (sortType.equals((Object)(sortOrderMatched ? QuerySortType.FORWARD : QuerySortType.REVERSE))) continue;
                return QuerySortType.EXTRA;
            }
            catch (ColumnNotFoundException e) {
                sortType = QuerySortType.EXTRA;
                break;
            }
        }
        return sortType;
    }

    public static byte[] getNextValueByPaddingZeroByte(byte[] value) {
        byte[] nextValue = new byte[value.length + 1];
        System.arraycopy(value, 0, nextValue, 0, value.length);
        nextValue[nextValue.length - 1] = 0;
        return nextValue;
    }

    public static void separateFilters(List<QueryFilterInfo> filtersForIndexTable, List<QueryFilterInfo> filtersForDataTable, TableMeta indexTable, List<QueryFilterInfo> filters) {
        HashSet<QueryFilterInfo> filterInfoSet = new HashSet<QueryFilterInfo>();
        for (QueryFilterInfo filter : filters) {
            List<ColumnSlot> columnSlots = filter.getColumnSlots();
            ArrayList<ColumnSlot> columnSlotsForIndexTable = new ArrayList<ColumnSlot>(columnSlots.size());
            ArrayList<ColumnSlot> columnSlotsForDataTable = filters.size() == 1 ? new ArrayList<ColumnSlot>(columnSlots.size()) : null;
            for (ColumnSlot columnSlot : columnSlots) {
                ColumnKey columnKey = IndexUtils.getIndexColumnKey(columnSlot.getColumn().getColumnKey(), indexTable);
                try {
                    indexTable.resolveColumn(columnKey);
                    columnSlotsForIndexTable.add(columnSlot);
                }
                catch (ColumnNotFoundException e) {
                    if (columnSlotsForDataTable == null) continue;
                    columnSlotsForDataTable.add(columnSlot);
                }
            }
            if (!columnSlotsForIndexTable.isEmpty()) {
                filterInfoSet.add(QueryFilterInfo.create(columnSlotsForIndexTable));
            }
            if (filters.size() == 1) {
                filtersForDataTable.add(QueryFilterInfo.create(columnSlotsForDataTable));
                continue;
            }
            filtersForDataTable.add(filter);
        }
        filtersForIndexTable.addAll(filterInfoSet);
    }

    public static QueryType getQueryType(List<IntervalQuery> intervalQueries) {
        if (intervalQueries == null || intervalQueries.isEmpty()) {
            return QueryType.INVALID;
        }
        boolean isPointLookUp = true;
        for (IntervalQuery intervalQuery : intervalQueries) {
            Interval interval = intervalQuery.getInterval();
            if (interval.isSingleValue()) continue;
            isPointLookUp = false;
        }
        if (isPointLookUp) {
            return QueryType.POINT_LOOK_UP;
        }
        return QueryType.SCAN;
    }

    public static enum QuerySortType {
        FORWARD(0),
        REVERSE(1),
        EXTRA(2);

        private final int code;

        private QuerySortType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static QuerySortType codeToType(int code) {
            for (QuerySortType type : QuerySortType.values()) {
                if (type.getCode() != code) continue;
                return type;
            }
            return null;
        }
    }

    public static enum QueryType {
        INVALID,
        POINT_LOOK_UP,
        SCAN;

    }
}

