/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.types.LDecimal;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.KeyHashFunction;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.exception.DataExceedsCapacityException;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.math.BigDecimal;

public abstract class LDataType<T> {
    protected final DataType clientType;
    protected final String name;
    protected final Class clazz;
    protected int ordinal;

    LDataType(DataType clientType, Class clazz) {
        this.clientType = clientType;
        this.name = clientType.toString();
        this.ordinal = clientType.ordinal();
        this.clazz = clazz;
    }

    public String getName() {
        return this.name;
    }

    public DataType getClientType() {
        return this.clientType;
    }

    public Class getJavaClass() {
        return this.clazz;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public static byte[] toBytes(LColumn meta, ColumnValue data) throws IllegalDataException {
        Preconditions.checkNotNull(data);
        LDataType actualType = LDataTypeFactory.INSTANCE.getTypeInstance(data.getType());
        return LDataType.toBytes(meta, data.getValueObject(), actualType);
    }

    public static byte[] toBytes(LColumn meta, Object value, LDataType actualType) throws IllegalDataException {
        return LDataType.toBytes(meta, value, actualType, true);
    }

    public static byte[] toBytes(LColumn meta, Object value, LDataType actualType, boolean padSuffix) throws IllegalDataException {
        if (meta.isPrimaryKey()) {
            if (value == null) {
                if (SchemaUtils.storePkNulls(meta)) {
                    byte[] ret = LDataType.getDefaultNullValue(meta, actualType);
                    if (meta.isHashed()) {
                        byte[] hashKey = KeyHashFunction.computeHashKeyFromRow(ret, 0, ret.length);
                        return Bytes.add(hashKey, ret);
                    }
                    return ret;
                }
                throw new IllegalDataException("Cannot write null value into primary key " + meta.toString());
            }
            try {
                LDataType metaType = meta.getDataType();
                value = DataTypeUtils.roundForDecimalIfNecessary(value, actualType, meta);
                byte[] ret = metaType.toBytes(value, actualType, meta.getSortOrder());
                ret = LDataType.addSuffixIfNecessary(meta, ret, padSuffix);
                if (SchemaUtils.storePkNulls(meta)) {
                    ret = Bytes.add(SchemaUtils.getValuePrefixBytes(meta.getSortOrder()), ret);
                }
                if (meta.isHashed()) {
                    byte[] hashKey = KeyHashFunction.computeHashKeyFromRow(ret, 0, ret.length);
                    return Bytes.add(hashKey, ret);
                }
                return ret;
            }
            catch (IllegalDataException e) {
                throw new IllegalDataException("Failed processing column value for " + meta.toString(), e);
            }
        }
        if (value == null) {
            return null;
        }
        try {
            LDataType metaType = meta.getDataType();
            if (metaType == actualType && metaType == LString.INSTANCE && ((String)value).isEmpty()) {
                return SchemaUtils.SEPARATOR_BYTES;
            }
            value = DataTypeUtils.roundForDecimalIfNecessary(value, actualType, meta);
            byte[] ret = metaType.toBytes(value, actualType, meta.getSortOrder());
            return LDataType.doPaddingIfNecessary(meta, ret);
        }
        catch (IllegalDataException e) {
            throw new IllegalDataException("Failed processing column value for " + meta.toString(), e);
        }
    }

    private static byte[] addSuffixIfNecessary(LColumn meta, byte[] ret) throws IllegalDataException {
        return LDataType.addSuffixIfNecessary(meta, ret, true);
    }

    private static byte[] addSuffixIfNecessary(LColumn meta, byte[] ret, boolean padSuffix) throws IllegalDataException {
        LDataType metaType = meta.getDataType();
        ret = LDataType.doPaddingIfNecessary(meta, ret);
        if (padSuffix && SchemaUtils.hasSeparatorByte(metaType)) {
            ret = Bytes.add(ret, SchemaUtils.getSeparatorBytes(meta.getSortOrder()));
        }
        return ret;
    }

    private static byte[] doPaddingIfNecessary(LColumn meta, byte[] value) throws DataExceedsCapacityException {
        Integer maxLength = meta.getMaxLength();
        if (DataTypeUtils.needPadding(meta.getDataType().getClientType())) {
            if (maxLength < value.length) {
                throw new DataExceedsCapacityException(meta.getDataType().getClientType(), maxLength, value.length);
            }
            return meta.getDataType().pad(value, maxLength, meta.getSortOrder());
        }
        return value;
    }

    private static byte[] getDefaultNullValue(LColumn meta, LDataType actualType) throws IllegalDataException {
        byte[] defaultValue = null;
        if (actualType.getClientType() == DataType.DECIMAL && meta.getDataType().getClientType() == DataType.DECIMAL) {
            BigDecimal bd = DataTypeUtils.setDecimalWidthAndScale(LDecimal.DEFAULT_NULL_VALUE, meta.getPrecision(), meta.getScale());
            defaultValue = LDecimal.INSTANCE.toBytes(bd);
        } else {
            defaultValue = meta.getDataType().getNullValue();
        }
        defaultValue = LDataType.addSuffixIfNecessary(meta, defaultValue);
        defaultValue = Bytes.add(SchemaUtils.getNullValuePrefixBytes(meta.getSortOrder()), defaultValue);
        return defaultValue;
    }

    public static Object toObject(LColumn meta, byte[] value) throws IllegalDataException {
        int length = value == null ? 0 : value.length;
        return LDataType.toObject(meta, value, 0, length);
    }

    public static Object toObject(LColumn meta, byte[] value, int offset, int length) throws IllegalDataException {
        LDataType metaType = meta.getDataType();
        if (meta.isPrimaryKey()) {
            if (SchemaUtils.storePkNulls(meta)) {
                byte prefix = value[offset];
                boolean isNullValue = SchemaUtils.isNullValueByte(prefix, meta.getSortOrder());
                if (isNullValue) {
                    return null;
                }
                ++offset;
                --length;
            }
            int actualLength = SchemaUtils.hasSeparatorByte(meta.getDataType()) ? length - 1 : length;
            return metaType.toObject(value, offset, actualLength, meta.getSortOrder());
        }
        if (length == 0) {
            return null;
        }
        if (metaType == LString.INSTANCE && LString.isEmptyString(value, offset, length)) {
            return "";
        }
        return metaType.toObject(value, offset, length, SortOrder.getDefault());
    }

    public abstract int getByteSize();

    public int getByteSize(Object o) {
        if (this.isFixedWidth()) {
            return this.getByteSize();
        }
        throw new UnsupportedOperationException();
    }

    public abstract boolean isFixedWidth();

    public abstract boolean isCastableTo(LDataType var1);

    public abstract byte[] toBytes(Object var1) throws IllegalDataException;

    public abstract byte[] toBytes(Object var1, SortOrder var2) throws IllegalDataException;

    public byte[] toBytes(Object value, LDataType actualType, SortOrder sortOrder) throws IllegalDataException {
        Object v = this.toObject(value, actualType);
        return this.toBytes(v, sortOrder);
    }

    public abstract Object toObject(Object var1, LDataType var2) throws IllegalDataException;

    public abstract Object toObject(byte[] var1) throws IllegalDataException;

    public abstract Object toObject(byte[] var1, int var2, int var3, SortOrder var4) throws IllegalDataException;

    public Interval getKeyInterval(byte[] lower, boolean lowerInclusive, byte[] upper, boolean upperInclusive) {
        if (lower != Interval.UNBOUND && !lowerInclusive && this.isFixedWidth()) {
            lower = CompilerUtils.nextKey(lower);
            lowerInclusive = true;
        }
        return Interval.create(lower, lowerInclusive, upper, upperInclusive);
    }

    public byte[] pad(byte[] value, int maxLength, SortOrder sortOrder) {
        throw new UnsupportedOperationException();
    }

    public byte[] getNullValue() throws IllegalDataException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClientType().toString();
    }
}

