/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class PrimaryKeyValueAccessor
extends VersionedObjectWithAttributes {
    public static final int ASC_SEPARATOR_BYTES_MARKER = -1;
    public static final int DESC_SEPARATOR_BYTES_MARKER = -2;
    public static final int VARBINARY_MARKER = -3;
    public static final int ENCODED_VARBINARY_MARKER = -4;
    private int totalLength;
    private int[] offsets;
    private int[] lengths;
    private byte[] hashTag;
    private boolean storeNull = false;

    public PrimaryKeyValueAccessor() {
    }

    public PrimaryKeyValueAccessor(int totalLength, int[] offsets, int[] lengths) {
        this.totalLength = totalLength;
        this.offsets = offsets;
        this.lengths = lengths;
    }

    public PrimaryKeyValueAccessor(int totalLength, int[] offsets, int[] lengths, byte[] hashTag) {
        this(totalLength, offsets, lengths);
        this.hashTag = hashTag;
    }

    public PrimaryKeyValueAccessor(List<LColumn> pkColumns) {
        this(pkColumns, false);
    }

    public PrimaryKeyValueAccessor(List<LColumn> pkColumns, boolean storeNull) {
        if (pkColumns == null || pkColumns.isEmpty()) {
            throw new IllegalArgumentException("Cannot create PK value accessor with empty PK schema");
        }
        this.storeNull = storeNull;
        this.compile(pkColumns);
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public boolean isStoreNull() {
        return this.storeNull;
    }

    public ParsedPKValueAccessor parseRowKey(byte[] rowkey) throws LindormException {
        return this.parseRowKey(new ImmutableBytesPtr(rowkey));
    }

    public ParsedPKValueAccessor parseRowKey(ImmutableBytesPtr ptr) throws LindormException {
        ParsedPKValueAccessor parsed;
        if (this.totalLength > 0) {
            if (ptr.getLength() < this.totalLength) {
                throw new IllegalDataException("Not enough bytes to parse PK columns, expected length:" + this.totalLength + ", actual length:" + ptr.getLength() + "=>" + Bytes.toStringBinary(ptr.get(), ptr.getOffset(), ptr.getLength()));
            }
            parsed = new ParsedPKValueAccessor(this.offsets, this.lengths, ptr);
        } else {
            int[] newOffsets = new int[this.lengths.length];
            int[] newLengths = new int[this.lengths.length];
            int offset = 0;
            int realOff = 0;
            for (int i = 0; i < this.lengths.length; ++i) {
                if (this.hashTag != null && this.hashTag.length > i && this.hashTag[i] == 1) {
                    offset += 8;
                }
                realOff = offset;
                int len = this.lengths[i];
                if (len < 0) {
                    if (this.storeNull) {
                        realOff = offset + 1;
                    }
                    len = PrimaryKeyValueAccessor.getLength(ptr, realOff, len);
                    if (this.storeNull) {
                        // empty if block
                    }
                }
                newLengths[i] = ++len;
                newOffsets[i] = offset;
                offset += len;
            }
            parsed = new ParsedPKValueAccessor(newOffsets, newLengths, ptr);
        }
        return parsed;
    }

    private void compile(List<LColumn> pkColumns) {
        this.offsets = new int[pkColumns.size()];
        this.lengths = new int[pkColumns.size()];
        this.hashTag = new byte[pkColumns.size()];
        int offset = 0;
        boolean hasVariableLengthPK = false;
        for (int i = 0; i < pkColumns.size(); ++i) {
            LColumn pk = pkColumns.get(i);
            LDataType type = pk.getDataType();
            if (pk.isHashed()) {
                this.hashTag[i] = 1;
            }
            if (type.isFixedWidth()) {
                int len = type.getClientType() == DataType.BINARY ? pk.getMaxLength().intValue() : pk.getDataType().getByteSize();
                if (pk.isHashed()) {
                    offset += 8;
                }
                this.offsets[i] = offset;
                if (this.storeNull) {
                    ++len;
                }
                offset += len;
                this.lengths[i] = len;
                continue;
            }
            hasVariableLengthPK = true;
            int marker = pk.getDataType().getClientType() == DataType.VARBINARY ? -3 : (pk.getDataType().getClientType() == DataType.ENCODED_VARBINARY ? -4 : (pk.getSortOrder() == SortOrder.ASC ? -1 : -2));
            this.lengths[i] = marker;
        }
        if (hasVariableLengthPK) {
            this.offsets = null;
            this.totalLength = 0;
        } else {
            this.totalLength = offset;
        }
    }

    private static int getLength(ImmutableBytesPtr ptr, int offset, int marker) {
        int start;
        int pos;
        byte[] buf = ptr.get();
        if (marker == -1) {
            for (pos = start = ptr.getOffset() + offset; pos < ptr.getOffset() + ptr.getLength() && !PrimaryKeyValueAccessor.isSeparatorByte(buf[pos]); ++pos) {
            }
            ++pos;
        } else if (marker == -2) {
            while (pos < ptr.getOffset() + ptr.getLength() && !PrimaryKeyValueAccessor.isSeparatorByteDesc(buf[pos])) {
                ++pos;
            }
            ++pos;
        } else if (marker == -3) {
            pos = ptr.getOffset() + ptr.getLength();
        } else {
            return DataTypeUtils.getEVarbinaryLen(buf, pos, ptr.getLength() - offset);
        }
        return pos - start;
    }

    private static boolean isSeparatorByte(byte b) {
        return b == 0;
    }

    private static boolean isSeparatorByteDesc(byte b) {
        return b == SchemaUtils.SEPARATOR_BYTE_DESC;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setAttribute("STORE_PK_NULLS", Bytes.toBytes(this.storeNull));
        this.setAttribute("PK_HASHED", this.hashTag);
        super.writeTo(out);
        WritableUtils.writeVIntArray(out, this.lengths);
        WritableUtils.writeVInt(out, this.totalLength);
        if (this.totalLength > 0) {
            WritableUtils.writeVIntArray(out, this.offsets);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        byte[] p;
        super.readFrom(in);
        this.lengths = WritableUtils.readVIntArray(in);
        this.totalLength = WritableUtils.readVInt(in);
        this.offsets = (int[])(this.totalLength > 0 ? WritableUtils.readVIntArray(in) : null);
        byte[] s = this.getAttribute("STORE_PK_NULLS");
        if (null != s) {
            this.storeNull = Bytes.toBoolean(s);
        }
        if (null != (p = this.getAttribute("PK_HASHED"))) {
            this.hashTag = p;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrimaryKeyValueAccessor)) {
            return false;
        }
        PrimaryKeyValueAccessor other = (PrimaryKeyValueAccessor)obj;
        if (this.totalLength != other.totalLength) {
            return false;
        }
        if (!Arrays.equals(this.offsets, other.offsets)) {
            return false;
        }
        if (!Arrays.equals(this.lengths, other.lengths)) {
            return false;
        }
        if (this.storeNull != other.storeNull) {
            return false;
        }
        return Bytes.equals(this.hashTag, other.hashTag);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[totalLength=");
        str.append(this.totalLength);
        str.append("]");
        if (this.totalLength > 0) {
            str.append(", offsets:[");
            for (int v : this.offsets) {
                str.append(v);
                str.append(",");
            }
            str.setLength(str.length() - 1);
            str.append("]");
        }
        str.append(", lengths:[");
        for (int v : this.lengths) {
            str.append(v);
            str.append(",");
        }
        str.setLength(str.length() - 1);
        str.append("]");
        if (null != this.hashTag) {
            str.append(", hash tag:[");
            for (byte b : this.hashTag) {
                str.append(b);
                str.append(",");
            }
            str.setLength(str.length() - 1);
            str.append("]");
        }
        str.append(", store null:[").append(this.storeNull).append("]");
        return str.toString();
    }

    public static class ParsedPKValueAccessor {
        private byte[] buf;
        private int offset;
        private int[] offsets;
        private int[] lengths;

        private ParsedPKValueAccessor(int[] offsets, int[] lengths, ImmutableBytesPtr rowkey) {
            this.offsets = offsets;
            this.lengths = lengths;
            this.buf = rowkey.get();
            this.offset = rowkey.getOffset();
        }

        public void getPKValue(int position, ImmutableBytesPtr ptr) {
            if (position < 0 || position >= this.offsets.length) {
                throw new IllegalArgumentException("PK position out of bound. actual=" + position + ", max=" + (this.offsets.length - 1));
            }
            ptr.set(this.buf, this.offset + this.offsets[position], this.lengths[position]);
        }
    }
}

