/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ExternalIndexField
extends VersionedObjectWithAttributes {
    private String family;
    private String qualifier;
    private String targetFeildName;
    private ValueType type;

    public ExternalIndexField() {
    }

    public ExternalIndexField(String family, String qualifier, String targetFieldName, ValueType type) {
        this.family = family;
        this.qualifier = qualifier;
        this.targetFeildName = targetFieldName;
        this.type = type;
    }

    public String getFamily() {
        return this.family;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getTargetFeildName() {
        return this.targetFeildName;
    }

    public ValueType getType() {
        return this.type;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.family);
        WritableUtils.writeString(out, this.qualifier);
        WritableUtils.writeString(out, this.targetFeildName);
        WritableUtils.writeString(out, this.type.name());
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.family = WritableUtils.readString(in);
        this.qualifier = WritableUtils.readString(in);
        this.targetFeildName = WritableUtils.readString(in);
        this.type = ValueType.valueOf(WritableUtils.readString(in));
    }

    public static enum ValueType {
        INT("int"),
        LONG("long"),
        STRING("string"),
        BOOLEAN("boolean"),
        FLOAT("float"),
        DOUBLE("double"),
        SHORT("short"),
        BIGDECIMAL("bigdecimal");

        private String valueType;

        private ValueType(String valueType) {
            this.valueType = valueType;
        }

        public String toString() {
            return this.valueType;
        }
    }
}

