/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.ExternalIndexRowFormatterType;
import com.alibaba.lindorm.client.core.meta.ExternalIndexType;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ExternalIndexConfig
extends VersionedObjectWithAttributes {
    private String targetIndexName = null;
    private ExternalIndexType indexType = null;
    private ExternalIndexRowFormatterType rowFormatterType = null;

    public ExternalIndexConfig() {
    }

    public ExternalIndexConfig(String targetIndexName, ExternalIndexType indexType, ExternalIndexRowFormatterType rowFormatterType) {
        this.targetIndexName = targetIndexName;
        if (indexType != null) {
            this.indexType = indexType;
        }
        if (rowFormatterType != null) {
            this.rowFormatterType = rowFormatterType;
        }
    }

    public String getTargetIndexName() {
        return this.targetIndexName;
    }

    public ExternalIndexType getIndexType() {
        return this.indexType;
    }

    public ExternalIndexRowFormatterType getRowFormatterType() {
        return this.rowFormatterType;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.targetIndexName);
        if (this.indexType == null) {
            WritableUtils.writeString(out, null);
        } else {
            WritableUtils.writeString(out, this.indexType.name());
        }
        if (this.rowFormatterType == null) {
            WritableUtils.writeString(out, null);
        } else {
            WritableUtils.writeString(out, this.rowFormatterType.name());
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.targetIndexName = WritableUtils.readString(in);
        String indexTypeStr = WritableUtils.readString(in);
        this.indexType = indexTypeStr == null || indexTypeStr.length() == 0 ? null : ExternalIndexType.valueOf(indexTypeStr);
        String rowFormatterTypeStr = WritableUtils.readString(in);
        this.rowFormatterType = rowFormatterTypeStr == null || rowFormatterTypeStr.length() == 0 ? null : ExternalIndexRowFormatterType.valueOf(rowFormatterTypeStr);
    }

    @Override
    public String toString() {
        return "targetIndexName=" + (this.targetIndexName == null ? "" : this.targetIndexName) + ", indexType=" + (Object)((Object)this.indexType) + ", rowFormatterType=" + (Object)((Object)this.rowFormatterType);
    }
}

