/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc.locator;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.ipc.LDServerList;
import com.alibaba.lindorm.client.core.ipc.LDServerLocator;
import com.alibaba.lindorm.client.core.ipc.locator.IDCSorter;
import com.alibaba.lindorm.client.core.ipc.locator.PingDelayMeasurer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IDCConfigSorter
extends IDCSorter {
    private static final Log LOG = LogFactory.getLog((String)IDCConfigSorter.class.getName());
    ConcurrentSkipListSet<String> suspectIdcs;
    List<String> priorityOrder;
    List<String> nearbyIDCConfig;
    PingDelayMeasurer measurer;
    FailureDetector detector;
    private List<String> availableIDCList = new ArrayList<String>();
    private List<String> nearbyIDCList = new ArrayList<String>();
    private volatile boolean isInit = false;
    private int pingLimit;
    private int detectorPause;

    public IDCConfigSorter(LindormClientConfig config, LDServerLocator locator) {
        super(config, locator);
        this.suspectIdcs = new ConcurrentSkipListSet();
        Class<?> pingMeasurerClass = config.getClass("lindorm.ping.delay.measurer.impl", "com.alibaba.lindorm.client.core.ipc.locator.PingDelayMeasurer", LindormClientConstants.LINDORM_PING_MEASURER_CLASS_DEFAULT);
        try {
            Constructor<?> meth = pingMeasurerClass.getDeclaredConstructor(LindormClientConfig.class);
            meth.setAccessible(true);
            this.measurer = (PingDelayMeasurer)meth.newInstance(config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.onConfigChange(config);
        this.detect();
        this.detector = new FailureDetector();
        this.detector.setDaemon(true);
        this.detector.start();
    }

    @Override
    public void onConfigChange(LindormClientConfig config) {
        super.onConfigChange(config);
        this.detectorPause = config.getInt("lindorm.rpc.idc.detect.interval", 10000);
        this.pingLimit = config.getInt("lindorm.rpc.idc.ping.number.limit", 3);
        String configVal = config.get("lindorm.client.idc.priority.list");
        if (configVal == null || !configVal.contains(",")) {
            throw new RuntimeException("Invalid priority list for IDC Config sorter, should format as idc1,idc2 but actually " + configVal);
        }
        List<String> temp = Arrays.asList(configVal.split(","));
        this.priorityOrder = temp;
        configVal = config.get("lindorm.client.idc.nearby.list");
        temp = new ArrayList<String>();
        if (configVal != null) {
            String[] nearbyIdcs;
            for (String idc : nearbyIdcs = configVal.split(",")) {
                if (!this.priorityOrder.contains(idc)) {
                    throw new RuntimeException("Invalid nearby idc settings, idc priority order " + this.priorityOrder + ", nearby idc: " + configVal);
                }
                temp.add(idc);
            }
        }
        this.nearbyIDCConfig = temp;
        this.measurer.onConfigChange(config);
    }

    @Override
    public void sortIDCs(LDServerList serverList, String priorityIDC) {
        List<String> idcList = serverList.getAllIDCNames();
        Collections.sort(idcList, new Comparator<String>(){

            @Override
            public int compare(String idc1, String idc2) {
                return IDCConfigSorter.this.compareEndpoints(idc1, idc2);
            }
        });
        Iterator<String> it = idcList.iterator();
        while (it.hasNext()) {
            if (!this.suspectIdcs.contains(it.next())) continue;
            it.remove();
        }
        if (this.isInit) {
            if (!this.availableIDCList.equals(idcList)) {
                LOG.warn((Object)("Sorted available idc list changed, old list " + this.availableIDCList + ", current " + idcList));
            }
        } else {
            this.isInit = true;
            LOG.warn((Object)("Init sorted available idc list" + idcList));
        }
        this.availableIDCList = idcList;
        if (this.nearbyIDCConfig != null) {
            ArrayList<String> temp = new ArrayList<String>();
            for (String idc : this.availableIDCList) {
                if (!this.nearbyIDCConfig.contains(idc)) continue;
                temp.add(idc);
            }
            this.nearbyIDCList = temp.isEmpty() ? this.availableIDCList : temp;
        } else {
            this.nearbyIDCList = this.availableIDCList;
        }
    }

    @Override
    public List<String> getAvailableIDCList() {
        return this.availableIDCList;
    }

    @Override
    public List<String> getNearbySortedIDCList() {
        return this.nearbyIDCList;
    }

    @Override
    public void triggerDetection() {
        this.detector.triggerNow();
    }

    @Override
    public String getSorterType() {
        return "CONFIGSORTER";
    }

    public int compareEndpoints(String idc1, String idc2) {
        int delayIdc2;
        if (idc1.equals(this.locator.getPriorityIDC())) {
            return -1;
        }
        if (idc2.equals(this.locator.getPriorityIDC())) {
            return 1;
        }
        int delayIdc1 = this.priorityOrder.indexOf(idc1);
        if (delayIdc1 == -1 || this.suspectIdcs.contains(idc1)) {
            delayIdc1 = Integer.MAX_VALUE;
        }
        if ((delayIdc2 = this.priorityOrder.indexOf(idc2)) == -1 || this.suspectIdcs.contains(idc2)) {
            delayIdc2 = Integer.MAX_VALUE;
        }
        return delayIdc1 - delayIdc2;
    }

    private void updateStatusForIDC(String idc, List<LDServerAddress> servers) {
        if (servers == null || servers.size() == 0) {
            this.suspectIdcs.add(idc);
            return;
        }
        Collections.shuffle(servers);
        int limit = Math.min(this.pingLimit, servers.size());
        for (int i = 0; i < limit; ++i) {
            LDServerAddress server = servers.get(i);
            try {
                this.measurer.getPingDelay(server);
                this.suspectIdcs.remove(idc);
                return;
            }
            catch (Throwable t) {
                LOG.info((Object)("Failed to get ping delay for server " + server), t);
                continue;
            }
        }
        if (this.suspectIdcs.add(idc)) {
            LOG.warn((Object)("Find unavailble idc, possibly a network partition: " + idc));
        }
    }

    private synchronized void detect() {
        List<String> idcs = this.locator.getAllIDC();
        for (String idc : idcs) {
            this.updateStatusForIDC(idc, this.locator.getServersOfIDC(idc));
        }
    }

    @Override
    public void close() {
        this.detector.close();
    }

    public class FailureDetector
    extends Thread {
        private volatile boolean isStopped = false;
        private final Object sleepLock = new Object();

        public FailureDetector() {
            this.setName("FailureDetector");
        }

        public void close() {
            this.isStopped = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isStopped) {
                Object object = this.sleepLock;
                synchronized (object) {
                    try {
                        this.sleepLock.wait(IDCConfigSorter.this.detectorPause);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                IDCConfigSorter.this.detect();
                IDCConfigSorter.this.sortIDCs(IDCConfigSorter.this.locator.getServerList(), IDCConfigSorter.this.locator.getPriorityIDC());
            }
            LOG.info((Object)(this.getName() + " exits"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void triggerNow() {
            Object object = this.sleepLock;
            synchronized (object) {
                this.sleepLock.notifyAll();
            }
        }
    }
}

