/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.utils.ExceptionUtils;
import com.alibaba.lindorm.client.exception.OperationTimeoutException;

public class TracePoint {
    private volatile long startTs;
    private volatile long endTs;
    private volatile LDServerAddress location;
    private volatile Throwable t;

    public TracePoint(LDServerAddress location, long startTs, long endTs, Throwable t) {
        this.startTs = startTs;
        this.endTs = endTs;
        this.location = location;
        this.t = t;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public long getTookTime() {
        return this.endTs - this.startTs;
    }

    public LDServerAddress getLocation() {
        return this.location;
    }

    public String getRemoteHost() {
        return this.location != null ? this.location.getHostname() : "";
    }

    public Throwable getThrowable() {
        return this.t;
    }

    public boolean isSuccess() {
        return this.t == null;
    }

    public boolean isTimeout() {
        return this.t != null && this.t instanceof OperationTimeoutException;
    }

    public String toString() {
        return "TracePoint{location=" + this.location + ", took=" + this.getTookTime() + (this.t == null ? "success" : ExceptionUtils.stringifyException(this.t)) + '}';
    }
}

