/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.ipc.ClientCompletableFuture;
import com.alibaba.lindorm.client.core.ipc.Connection;
import com.alibaba.lindorm.client.core.ipc.Invocation;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RpcClient;
import com.alibaba.lindorm.client.core.ipc.RpcOptionalParams;
import com.alibaba.lindorm.client.exception.TimeoutException;
import com.alibaba.lindorm.thirdparty.netty.util.HashedWheelTimer;
import com.alibaba.lindorm.thirdparty.netty.util.Timeout;
import com.alibaba.lindorm.thirdparty.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Request {
    private static final Log LOG = LogFactory.getLog((String)Request.class.getName());
    public static final int PENDINGID = -1;
    private volatile int myID = -1;
    private volatile Connection connection;
    private final RpcClient rpcClient;
    private final long startTime;
    private volatile long serverReceiveTS = -1L;
    private volatile int serverExecutionTime = -1;
    private volatile long sendTime;
    private volatile RpcOptionalParams optionalParameters;
    private final ClientCompletableFuture<Object> future = new ClientCompletableFuture();
    private final AsyncCallback callback;
    private AtomicBoolean alreadyCallBack = new AtomicBoolean(false);
    private final Invocation invocation;
    private final int timeout;
    private volatile Timeout timeoutHandle;
    private volatile OperationContext operationContext;
    private volatile TimerTask timeoutTask;

    public Request(RpcClient client, Invocation invocation, AsyncCallback callback, int timeout) {
        this.rpcClient = client;
        this.invocation = invocation;
        this.callback = callback;
        this.startTime = System.currentTimeMillis();
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getId() {
        return this.myID;
    }

    public void setId(int rpcId) {
        this.myID = rpcId;
    }

    public RpcOptionalParams getOptionalParams() {
        if (this.optionalParameters == null) {
            this.optionalParameters = new RpcOptionalParams();
        }
        return this.optionalParameters;
    }

    public void setClientWaitTime(int clientWaitTime) {
        this.getOptionalParams().setMaxClientWaitTime(clientWaitTime);
    }

    public void setServerReceiveTimestamp(long timestamp) {
        this.serverReceiveTS = timestamp;
    }

    public void setServerExecutionTime(int executionTime) {
        this.serverExecutionTime = executionTime;
    }

    public void setClientSendTime(long timestamp) {
        this.sendTime = timestamp;
        this.getOptionalParams().setClientSendTime(timestamp);
    }

    public void setDoAsUser(String doAsUser) {
        if (doAsUser != null) {
            this.getOptionalParams().setDoAsUser(doAsUser);
        }
    }

    public void setSkipConsistencyCheck(boolean skipConsistencyCheck) {
        this.getOptionalParams().setSkipConsistencyCheck(skipConsistencyCheck);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public ClientCompletableFuture<Object> getFuture() {
        return this.future;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public void setOperationContext(OperationContext operationContext) {
        this.operationContext = operationContext;
    }

    private void cancelTimeTask() {
        if (this.timeoutHandle != null) {
            this.timeoutHandle.cancel();
        }
    }

    public boolean isAsyncRetry() {
        return this.callback != null && this.callback.isRetrying();
    }

    public boolean isBlockable() {
        return this.callback == null ? true : this.callback.isBlockable();
    }

    public final void callback(final Object result) {
        block10: {
            this.cancelTimeTask();
            boolean success = this.alreadyCallBack.compareAndSet(false, true);
            if (!success) {
                return;
            }
            if (this.callback != null) {
                if (this.operationContext != null) {
                    this.operationContext.markOperationPoint(System.currentTimeMillis() - this.startTime, OperationContext.OperationPointType.WAIT_RESPONSE, this);
                }
                try {
                    if (result instanceof Throwable) {
                        this.rpcClient.getCallbackThreadPool().execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    Request.this.callback.onError((Throwable)result);
                                }
                                catch (Throwable t) {
                                    LOG.error((Object)("Error happened when called back on error " + Request.this), t);
                                }
                            }
                        });
                        break block10;
                    }
                    if (this.callback.shouldProcessResultInPool()) {
                        this.rpcClient.getCallbackThreadPool().execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    Request.this.callback.onComplete(result);
                                }
                                catch (Throwable t) {
                                    LOG.error((Object)("Error happened when called back on result " + Request.this), t);
                                }
                            }
                        });
                        break block10;
                    }
                    this.callback.onComplete(result);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error happened when called back request " + this), t);
                }
            } else if (result instanceof Throwable) {
                this.future.completeExceptionally((Throwable)result);
            } else {
                this.future.complete(result);
            }
        }
    }

    void setWaitTime() {
        this.setClientWaitTime(this.timeout);
    }

    public void enqueueTimeout(Connection connection, HashedWheelTimer timer) {
        if (this.timeout > 0) {
            this.connection = connection;
            if (this.timeoutTask == null) {
                this.timeoutTask = new TimeoutTask();
            }
            try {
                if (this.timeoutHandle != null) {
                    this.timeoutHandle.cancel();
                    LOG.warn((Object)("Request " + this + " had a previous timeout task"));
                }
                this.timeoutHandle = timer.newTimeout(this.timeoutTask, this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (IllegalStateException e) {
                LOG.warn((Object)("Failed to schedule RPC timeout: " + this + "  Ignore this if we're shutting down."), (Throwable)e);
                this.timeoutHandle = null;
            }
        } else {
            this.callback(new TimeoutException("Waited " + (System.currentTimeMillis() - this.startTime) + "ms for request" + this));
        }
    }

    public boolean isRead() {
        return this.operationContext != null && OperationContext.isUserReadOperation(this.operationContext.getOperationType());
    }

    public boolean isWrite() {
        return this.operationContext != null && OperationContext.isUserWriteOperation(this.operationContext.getOperationType());
    }

    public boolean isIndex() {
        return this.operationContext != null && this.operationContext.getOperationType() == OperationContext.OperationType.INDEXMULTI;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.invocation != null) {
            builder.append("Request Invocation=[");
            builder.append(this.invocation.toSimpleString() + "] ");
        }
        if (this.connection != null) {
            builder.append("host=" + this.connection.getHostAndPort() + ", requestID=");
            builder.append(this.myID);
        }
        builder.append(", timeout=");
        builder.append(this.timeout);
        return builder.toString();
    }

    private final class TimeoutTask
    implements TimerTask {
        boolean alreadyDelayed = false;
        int delayedTimeAtStart = Request.access$200(Request.this) != null ? Request.access$200(Request.this).getVMPauseDelayTime() : 0;

        private TimeoutTask() {
        }

        @Override
        public void run(Timeout timeOut) {
            OperationContext ctx = Request.this.operationContext;
            if (ctx != null && !this.alreadyDelayed) {
                long now;
                int relativePauseTime = ctx.getVMPauseDelayTime() - this.delayedTimeAtStart;
                long deadlineAfterDelayed = Request.this.startTime + (long)Request.this.timeout + (long)relativePauseTime;
                if (deadlineAfterDelayed > (now = System.currentTimeMillis())) {
                    this.alreadyDelayed = true;
                    long newDelay = deadlineAfterDelayed - now;
                    Request.this.timeoutHandle = Request.this.rpcClient.getRpcTimeoutTimer().newTimeout(this, newDelay, TimeUnit.MILLISECONDS);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Delayed a request for " + newDelay + " ms, callId=" + Request.this.myID + " connection=" + Request.this.connection));
                    }
                    return;
                }
            }
            if (Request.this.timeoutHandle == null) {
                LOG.error((Object)("Received a timeout handle " + timeOut + " but this RPC did not have one " + this));
            }
            if (timeOut != Request.this.timeoutHandle) {
                LOG.error((Object)("Receieved a timeout handle " + timeOut + " that doesn't match our own " + this));
            }
            if (Request.this.connection != null) {
                Request.this.connection.removeRpc(Request.this);
            }
            Request.this.callback(new TimeoutException("Waited " + (System.currentTimeMillis() - Request.this.startTime) + "ms for request" + Request.this));
        }
    }
}

