/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.ipc.Attributes;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.ipc.LDServerList;
import com.alibaba.lindorm.client.core.ipc.LDServerLocator;
import com.alibaba.lindorm.client.core.ipc.LocationCache;
import com.alibaba.lindorm.client.core.ipc.locator.IDCConfigSorter;
import com.alibaba.lindorm.client.core.ipc.locator.IDCNameSorter;
import com.alibaba.lindorm.client.core.ipc.locator.IDCPingSorter;
import com.alibaba.lindorm.client.core.ipc.locator.IDCSorter;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.exception.NoServerFoundInIDCException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultLDServerLocator
implements LDServerLocator {
    private static final Log LOG = LogFactory.getLog((String)DefaultLDServerLocator.class.getName());
    private Random random = new Random();
    private LConnection lConnection;
    private ConcurrentHashMap<String, LocationCache> cacheMap = new ConcurrentHashMap();
    private volatile LDServerList serverList = new LDServerList();
    private ConcurrentHashMap<String, Set<LDServerAddress>> bannedServers = new ConcurrentHashMap();
    private ConcurrentHashMap<LDServerAddress, Long> serverLastErrorTime = new ConcurrentHashMap();
    private IDCSorter idcSorter;
    private LindormClientConfig config;
    private String requestMode;
    private volatile String priorityIDC = null;
    private boolean skipErrorLocation;
    private long errorLocationExpireTime;

    public DefaultLDServerLocator(LindormClientConfig config, LConnection lConnection) throws LindormException {
        this.lConnection = lConnection;
        this.onConfigChange(config);
    }

    @Override
    public void onConfigChange(LindormClientConfig config) throws LindormException {
        this.config = config;
        this.priorityIDC = config.get("lindorm.client.priority.idc");
        String tmpRequestMode = this.config.get("lindorm.client.requestmode", "MULTI").toUpperCase();
        if (!LindormClientConstants.AVAILABLEMODE.contains(tmpRequestMode)) {
            throw new LindormException("Request mode " + tmpRequestMode + " is not supported!");
        }
        if ("SINGLE".equals(tmpRequestMode) && this.priorityIDC == null) {
            throw new LindormException("Must specify priority idc when Request mode SINGLE!");
        }
        this.requestMode = tmpRequestMode;
        if (this.idcSorter == null) {
            this.idcSorter = this.createIDCSorter(config);
        } else {
            String sorterType = config.getString("lindorm.client.sorter.type", "PINGSORTER");
            if (!sorterType.equals(this.idcSorter.getSorterType())) {
                IDCSorter newIdcSorter = this.createIDCSorter(config);
                newIdcSorter.sortIDCs(this.serverList, this.priorityIDC);
                IDCSorter oldSorter = this.idcSorter;
                this.idcSorter = newIdcSorter;
                oldSorter.close();
            } else {
                this.idcSorter.onConfigChange(config);
                this.idcSorter.sortIDCs(this.serverList, this.priorityIDC);
            }
        }
        this.skipErrorLocation = config.getBoolean("lindorm.rpc.skip.error.location", true);
        this.errorLocationExpireTime = config.getLong("lindorm.rpc.error.location.time", 30000L);
    }

    private IDCSorter createIDCSorter(LindormClientConfig config) throws LindormException {
        String sorterType = config.getString("lindorm.client.sorter.type", "PINGSORTER");
        if (sorterType.equals("PINGSORTER")) {
            return new IDCPingSorter(config, this);
        }
        if (sorterType.equals("CONFIGSORTER")) {
            return new IDCConfigSorter(config, this);
        }
        if (sorterType.equals("NAMESORTER")) {
            return new IDCNameSorter(config, this);
        }
        throw new LindormException("Unrecoginized sorter type: " + sorterType);
    }

    private void updateServerListNow() {
        this.lConnection.updateConfigNow();
    }

    @Override
    public void cacheLocation(LocationCache.Location location) throws IOException {
        LocationCache oldLocationCache;
        String idc = location.getAddress().getIdc();
        if (idc == null) {
            return;
        }
        this.serverList.addLDServerAddress(location.getAddress());
        LocationCache locationCache = this.cacheMap.get(idc);
        if (locationCache == null && (oldLocationCache = this.cacheMap.putIfAbsent(idc, locationCache = new LocationCache())) != null) {
            locationCache = oldLocationCache;
        }
        locationCache.cacheLocation(location);
    }

    @Override
    public List<String> getAllIDC() {
        return this.serverList.getAllIDCNames();
    }

    @Override
    public String getSingleRequestIDC() {
        if (this.requestMode.equals("SINGLE")) {
            return this.priorityIDC;
        }
        return null;
    }

    @Override
    public String getPriorityIDC() {
        return this.priorityIDC;
    }

    @Override
    public List<String> getAvailableIDCs(boolean pickNearby) {
        if (this.requestMode.equals("SINGLE")) {
            ArrayList<String> idcs = new ArrayList<String>();
            idcs.add(this.priorityIDC);
            return idcs;
        }
        List<String> idcs = !pickNearby ? this.idcSorter.getAvailableIDCList() : this.idcSorter.getNearbySortedIDCList();
        if (idcs.isEmpty()) {
            idcs = this.serverList.getAllIDCNames();
        }
        if (this.requestMode.equals("RANDOM")) {
            Collections.shuffle(idcs);
        }
        return idcs;
    }

    @Override
    public List<LDServerAddress> updateServerList(List<LDServerAddress> newServers) throws IOException {
        ArrayList<LDServerAddress> expiredServers = new ArrayList<LDServerAddress>();
        if (newServers != null) {
            this.serverList.updateFromSeedServer(newServers, expiredServers);
        }
        this.idcSorter.sortIDCs(this.serverList, this.priorityIDC);
        for (LDServerAddress expiredServer : expiredServers) {
            this.deleteServerCache(expiredServer);
        }
        return expiredServers;
    }

    @Override
    public List<LDServerAddress> getServersOfIDC(String idc) {
        return this.serverList.getLDServerByIDC(idc);
    }

    @Override
    public LDServerList getServerList() {
        return this.serverList;
    }

    @Override
    public LocationCache getLocationCacheOfIDC(String idc) {
        return this.cacheMap.get(idc);
    }

    @Override
    public LocationCache.Location getCachedLocation(String idc, DmlOperation operation) {
        if (operation == null || operation.getKey() == null) {
            return null;
        }
        LocationCache cache = this.cacheMap.get(idc);
        if (cache == null) {
            return null;
        }
        return cache.getCachedLocation(operation.getNamespace(), operation.getTableName(), operation.getKey());
    }

    @Override
    public LDServerAddress locateServer(String idc, DmlOperation operation, boolean useCache) throws IOException {
        LocationCache cache;
        byte[] key;
        LDServerAddress addressToReturn = null;
        LocationCache.Location location = null;
        if (useCache && operation != null && (key = operation.getKey()) != null && (cache = this.cacheMap.get(idc)) != null && (location = cache.getCachedLocation(operation.getNamespace(), operation.getTableName(), key)) != null) {
            addressToReturn = location.getAddress();
        }
        if (!(operation == null || useCache && addressToReturn != null)) {
            operation.setAttribute(Attributes.NEEDROUTE, Attributes.EMPTYVALUE);
        } else if (operation != null) {
            operation.removeAttribute(Attributes.NEEDROUTE);
        }
        if (location != null) {
            operation.setLocation(location);
        }
        if (addressToReturn != null) {
            return addressToReturn;
        }
        return this.randomActiveServer(idc);
    }

    private LDServerAddress randomActiveServer(String idc) throws NoServerFoundInIDCException {
        List<LDServerAddress> servers = this.getServersOfIDC(idc);
        HashSet<LDServerAddress> serverSet = null;
        if (servers != null) {
            serverSet = new HashSet<LDServerAddress>(servers);
            serverSet.removeAll(this.getBannedServersForIDC(idc));
            if (this.skipErrorLocation) {
                serverSet.removeAll(this.serverLastErrorTime.keySet());
            }
        }
        if (serverSet == null || serverSet.isEmpty()) {
            this.updateServerListNow();
            String msg = "No active server found in IDC " + idc + " Server Last error " + this.serverLastErrorTime + " banned " + this.bannedServers + this.getServersOfIDC(idc) + this;
            this.bannedServers.remove(idc);
            this.serverLastErrorTime.clear();
            throw new NoServerFoundInIDCException(msg);
        }
        return (LDServerAddress)serverSet.toArray()[this.random.nextInt(serverSet.size())];
    }

    @Override
    public void removeLDServer(LDServerAddress address) {
        if (address == null || address.getIdc() == null) {
            return;
        }
        this.serverList.removeLDServerAddress(address);
        this.markLocationError(address);
        if (this.serverList.getLDServerByIDC(address.getIdc()).size() < 3) {
            this.updateServerListNow();
        }
    }

    @Override
    public void markLocationError(LDServerAddress address) {
        if (address == null || address.getIdc() == null || !this.skipErrorLocation) {
            return;
        }
        if (this.serverLastErrorTime.get(address) != null) {
            this.deleteServerCache(address);
        }
        this.serverLastErrorTime.put(address, System.currentTimeMillis());
        if (this.serverLastErrorTime.size() > 3) {
            this.idcSorter.triggerDetection();
        }
    }

    @Override
    public void cleanErrorLocation(LDServerAddress address) {
        if (address == null || address.getIdc() == null || !this.skipErrorLocation) {
            return;
        }
        this.serverLastErrorTime.remove(address);
    }

    @Override
    public void cleanExpiredErrorLocations() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<LDServerAddress, Long>> iterator = this.serverLastErrorTime.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<LDServerAddress, Long> entry = iterator.next();
            if (entry.getValue() + this.errorLocationExpireTime >= now) continue;
            iterator.remove();
        }
    }

    @Override
    public void deleteCachedLocation(String idc, DmlOperation op) {
        if (idc == null) {
            return;
        }
        LocationCache cache = this.cacheMap.get(idc);
        if (cache != null && op != null && op.getKey() != null) {
            cache.deleteCachedLocation(op.getNamespace(), op.getTableName().getBytes(), op.getKey());
        }
    }

    @Override
    public void deleteServerCache(LDServerAddress server) {
        LocationCache cache;
        if (server.getIdc() != null && (cache = this.cacheMap.get(server.getIdc())) != null) {
            cache.deleteCachedLocationForServer(server);
        }
    }

    private Set<LDServerAddress> getBannedServersForIDC(String idc) {
        Set<LDServerAddress> exist;
        Set<LDServerAddress> servers = this.bannedServers.get(idc);
        if (servers == null && (exist = this.bannedServers.putIfAbsent(idc, servers = Collections.newSetFromMap(new ConcurrentHashMap()))) != null) {
            servers = exist;
        }
        return servers;
    }

    @Override
    public void banServer(LDServerAddress server) {
        if (server != null) {
            this.getBannedServersForIDC(server.getIdc()).add(server);
            this.deleteServerCache(server);
        }
    }

    @Override
    public void unbanServer(LDServerAddress server) {
        this.getBannedServersForIDC(server.getIdc()).remove(server);
    }

    @Override
    public boolean isServerBanned(LDServerAddress server) {
        return this.getBannedServersForIDC(server.getIdc()).contains(server);
    }

    @Override
    public void close() {
        this.idcSorter.close();
    }
}

