/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.feedstreamservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class StreamScan {
    public static final List<String> READ_ALL_TAGS = null;
    public static final List<String> READ_NO_TAGS = Collections.emptyList();
    public static final int NO_LIMIT = 0;
    private long startMessageId = 0L;
    private long endMessageId = Long.MAX_VALUE;
    private int limit = 0;
    private List<String> tagsToRead = READ_ALL_TAGS;

    public StreamScan setStartMessageId(long startMessageId) {
        this.startMessageId = startMessageId;
        return this;
    }

    public long getStartMessageId() {
        return this.startMessageId;
    }

    public StreamScan setEndMessageId(long endMessageId) {
        this.endMessageId = endMessageId;
        return this;
    }

    public long getEndMessageId() {
        return this.endMessageId;
    }

    public StreamScan addTag(String ... tags) {
        if (tags == null || tags.length == 0) {
            throw new IllegalArgumentException("Please set at least one tag key.");
        }
        if (this.tagsToRead == null || this.tagsToRead == READ_NO_TAGS) {
            this.tagsToRead = new ArrayList<String>(tags.length);
        }
        for (String tag : tags) {
            if (tag == null || tag.isEmpty()) {
                throw new IllegalArgumentException("Please specify valid tag key, but found null or empty key. tags=" + Arrays.toString(tags));
            }
            this.tagsToRead.add(tag);
        }
        return this;
    }

    public StreamScan allTags(boolean allOrNone) {
        this.tagsToRead = allOrNone ? READ_ALL_TAGS : READ_NO_TAGS;
        return this;
    }

    public List<String> getTagsToRead() {
        return this.tagsToRead;
    }

    public void setLimit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit must be greater than 0, but has " + limit);
        }
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isGetScan() {
        return this.startMessageId == this.endMessageId && this.startMessageId != 0L;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("StreamScan");
        if (this.startMessageId != 0L) {
            str.append("[");
            str.append(this.startMessageId);
        } else {
            str.append("(*");
        }
        str.append(", ");
        if (this.endMessageId != Long.MAX_VALUE) {
            str.append(this.endMessageId);
        } else {
            str.append("*");
        }
        str.append(")");
        if (this.limit != 0) {
            str.append(", limit = ");
            str.append(this.limit);
        }
        if (this.tagsToRead != READ_ALL_TAGS) {
            if (this.tagsToRead == READ_NO_TAGS) {
                str.append("no_tag");
            } else {
                str.append(", tags = ");
                str.append(this.tagsToRead);
            }
        }
        return str.toString();
    }
}

