/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.meta.Tuple;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class MultipleValuesExpression
extends Condition {
    private static LDataTypeFactory TYPE_FACTORY = LDataTypeFactory.INSTANCE;
    protected ColumnKey columnKey;
    protected DataType type;
    protected List<Object> values;

    public MultipleValuesExpression() {
    }

    public MultipleValuesExpression(byte[] columnName, Object ... values) throws LindormException {
        this(null, columnName, Arrays.asList(values));
    }

    public MultipleValuesExpression(byte[] familyName, byte[] columnName, Object ... values) throws LindormException {
        this(familyName, columnName, Arrays.asList(values));
    }

    public MultipleValuesExpression(byte[] columnName, List<Object> values) throws LindormException {
        this(null, columnName, values);
    }

    public MultipleValuesExpression(byte[] familyName, byte[] columnName, List<Object> values) throws LindormException {
        if (values == null || values.size() == 0) {
            throw new IllegalDataException("This expression with null or empty values is not supported.");
        }
        this.checkValueTypes(values);
        this.type = TYPE_FACTORY.getTypeByClass(values.get(0).getClass()).getClientType();
        this.columnKey = new ColumnKey(familyName, columnName);
        this.values = values;
    }

    private void checkValueTypes(List<Object> values) throws LindormException {
        DataType type = null;
        for (Object value : values) {
            DataType clientType = TYPE_FACTORY.getTypeByClass(value.getClass()).getClientType();
            if (type == null) {
                type = clientType;
                continue;
            }
            if (clientType.equals((Object)type)) continue;
            throw new IllegalDataException("This expression with different types is not supported. The type of " + value.toString() + " is not " + (Object)((Object)type));
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        this.columnKey.writeTo(out);
        WritableUtils.writeVInt(out, this.type.ordinal());
        WritableUtils.writeVInt(out, this.values.size());
        switch (this.type) {
            case DECIMAL: {
                for (Object value : this.values) {
                    byte[] valueBytes = Bytes.toBytes((BigDecimal)value);
                    Bytes.writeByteArray(out, valueBytes);
                }
                break;
            }
            case ENCODED_VARBINARY: {
                for (Object value : this.values) {
                    byte[] valueBytes = (byte[])value;
                    Bytes.writeByteArray(out, valueBytes);
                }
                break;
            }
            default: {
                LDataType typeInstance = LDataTypeFactory.INSTANCE.getTypeInstance(this.type);
                for (Object value : this.values) {
                    byte[] valueBytes = typeInstance.toBytes(value);
                    Bytes.writeByteArray(out, valueBytes);
                }
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.columnKey = new ColumnKey();
        this.columnKey.readFrom(in);
        int ordinal = WritableUtils.readVInt(in);
        this.type = LDataTypeFactory.INSTANCE.getClientTypeByOrdinal(ordinal);
        int size = WritableUtils.readVInt(in);
        this.values = new ArrayList<Object>(size);
        switch (this.type) {
            case DECIMAL: {
                for (int i = 0; i < size; ++i) {
                    byte[] valueBytes = Bytes.readByteArray(in);
                    this.values.add(Bytes.toBigDecimal(valueBytes));
                }
                break;
            }
            case ENCODED_VARBINARY: {
                for (int i = 0; i < size; ++i) {
                    this.values.add(Bytes.readByteArray(in));
                }
                break;
            }
            default: {
                LDataType typeInstance = LDataTypeFactory.INSTANCE.getTypeInstance(this.type);
                for (int i = 0; i < size; ++i) {
                    byte[] valueBytes = Bytes.readByteArray(in);
                    this.values.add(typeInstance.toObject(valueBytes));
                }
            }
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesPtr result) throws LindormException {
        throw new LindormException("This expression can not be evaluated");
    }

    @Override
    public abstract <T> T accept(ExpressionVisitor<T> var1) throws LindormException;

    @Override
    public void reset() {
    }

    public ColumnKey getColumnKey() {
        return this.columnKey;
    }

    public DataType getType() {
        return this.type;
    }

    public List<Object> getValues() {
        return this.values;
    }
}

