/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScanRanges {
    private static final Log LOG = LogFactory.getLog(ScanRanges.class);
    private final boolean isPointLookup;
    private List<Interval> ranges;
    private boolean isDegenerate;
    public static final ScanRanges EVERYTHING = new ScanRanges(Collections.singletonList(Interval.EVERYTHING_RANGE), false);

    public static ScanRanges create(List<Interval> intervals, boolean isPointLookup) {
        return new ScanRanges(intervals, isPointLookup);
    }

    public static ScanRanges create(ScanRanges other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot clone a null ScanRange object");
        }
        return new ScanRanges(other.getRanges(), other.isPointLookup);
    }

    private ScanRanges(List<Interval> ranges, boolean isPointLookup) {
        this.ranges = ranges == null ? Collections.emptyList() : ranges;
        this.isPointLookup = isPointLookup;
        this.processEmptyRanges();
    }

    public List<Interval> getRanges() {
        return this.ranges;
    }

    public boolean isDegenerate() {
        return this.isDegenerate;
    }

    public boolean isEverything() {
        return this == EVERYTHING || this.ranges.get(0) == Interval.EVERYTHING_RANGE;
    }

    public boolean isPointLookUp() {
        return this.isPointLookup;
    }

    public int getPointLookUpCount() {
        return this.isPointLookup ? this.ranges.size() : 0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("@");
        str.append(this.ranges.size());
        str.append("[");
        for (Interval itvl : this.ranges) {
            str.append(itvl.toString());
            str.append(",");
        }
        str.setLength(str.length() - 1);
        str.append("]");
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ScanRanges)) {
            return false;
        }
        ScanRanges other = (ScanRanges)obj;
        if (this.isPointLookup != other.isPointLookup) {
            return false;
        }
        return this.ranges.equals(other.ranges);
    }

    private void processEmptyRanges() {
        ArrayList<Interval> tmp = CollectionUtils.newArrayListWithCapacity(this.ranges.size());
        for (Interval itvl : this.ranges) {
            if (itvl == Interval.EMPTY_RANGE) continue;
            tmp.add(itvl);
        }
        if (tmp.isEmpty()) {
            this.isDegenerate = true;
        } else {
            this.ranges = tmp;
            this.isDegenerate = false;
        }
    }
}

