/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.BaseExpressionVisitor;
import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.compile.KeySlot;
import com.alibaba.lindorm.client.core.expression.AndExpression;
import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.expression.OrExpression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.ArrayList;
import java.util.List;

public class PrimaryKeyExpressionVisitor
extends BaseExpressionVisitor<List<KeySlot>> {
    private TableMeta table;

    public PrimaryKeyExpressionVisitor(TableMeta table) {
        this.table = table;
    }

    @Override
    public List<KeySlot> visitLeave(AndExpression node, List<List<KeySlot>> results) throws LindormException {
        if (results == null || results.isEmpty()) {
            return null;
        }
        KeySlot[] tmp = new KeySlot[this.table.getPkColumns().size()];
        for (List<KeySlot> slots : results) {
            assert (slots != null);
            for (KeySlot ks : slots) {
                assert (ks != null);
                KeySlot old = tmp[ks.getPkPosition()];
                if (old == null) {
                    tmp[ks.getPkPosition()] = ks;
                    continue;
                }
                if (old.isSpan() != ks.isSpan()) {
                    throw new LindormException("Illegal AND expression, is it deliberate? " + node.toString());
                }
                tmp[ks.getPkPosition()] = KeySlot.intersect(old, ks);
            }
        }
        KeySlot span = KeySlot.tryCreateSpan(tmp);
        return span != null ? CollectionUtils.newArrayList(span) : CollectionUtils.newArrayListSkipNull(tmp);
    }

    @Override
    public List<KeySlot> visitLeave(OrExpression node, List<List<KeySlot>> results) throws LindormException {
        if (results == null || results.size() == 0) {
            return null;
        }
        if (node.getConditions().size() != results.size()) {
            return null;
        }
        Integer pkPosition = null;
        boolean isSpan = false;
        ArrayList<KeySlot> slotsToOR = CollectionUtils.newArrayListWithCapacity(results.size());
        for (List<KeySlot> slots : results) {
            for (KeySlot ks : slots) {
                assert (ks != null);
                if (pkPosition == null) {
                    pkPosition = ks.getPkPosition();
                    isSpan = ks.isSpan();
                    slotsToOR.add(ks);
                    continue;
                }
                if (pkPosition.intValue() != ks.getPkPosition() || isSpan != ks.isSpan()) {
                    return null;
                }
                slotsToOR.add(ks);
            }
        }
        ArrayList<KeySlot> ret = slotsToOR;
        if (slotsToOR.size() > 0) {
            KeySlot first = (KeySlot)slotsToOR.get(0);
            for (int i = 1; i < slotsToOR.size(); ++i) {
                first = KeySlot.union(first, (KeySlot)slotsToOR.get(i));
            }
            ret = CollectionUtils.newArrayListWithCapacity(1);
            ret.add(first);
        }
        return ret;
    }

    @Override
    public List<KeySlot> visit(ComparisonExpression node) throws LindormException {
        LColumn column = this.table.resolveColumnNoThrow(node.getColumnKey());
        if (column != null && column.isPrimaryKey()) {
            ArrayList<Interval> ranges = CollectionUtils.newArrayList();
            if (node.getOp() == ConditionFactory.CompareOp.NOT_EQUAL) {
                ranges.addAll(CompilerUtils.getKeyIntervalForNotEqual(column, node));
            } else {
                ranges.add(CompilerUtils.getKeyInterval(column, node));
            }
            KeySlot ks = new KeySlot(column, ranges, CollectionUtils.newHashSet(node));
            ArrayList<KeySlot> ret = new ArrayList<KeySlot>();
            ret.add(ks);
            return ret;
        }
        return null;
    }
}

