/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client;

import com.alibaba.lindorm.client.AdminService;
import com.alibaba.lindorm.client.ExporterService;
import com.alibaba.lindorm.client.FeedStreamService;
import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.ServiceProvider;
import com.alibaba.lindorm.client.SystemService;
import com.alibaba.lindorm.client.TableService;
import com.alibaba.lindorm.client.WideColumnService;
import com.alibaba.lindorm.client.exception.LindormException;
import java.lang.reflect.Constructor;

public class LindormServiceProvider {
    public static ServiceProvider getServiceProvider(LindormClientConfig config) throws LindormException {
        try {
            Class<?> serviceProviderClass = config.getClass("lindorm.service.provider.impl", "com.alibaba.lindorm.client.DefaultServiceProviderImpl");
            Constructor<?> meth = serviceProviderClass.getDeclaredConstructor(new Class[0]);
            meth.setAccessible(true);
            return (ServiceProvider)meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    public static class SystemServiceProvider {
        public static SystemService create(LindormClientConfig config) throws LindormException {
            ServiceProvider provider = LindormServiceProvider.getServiceProvider(config);
            return provider.createSystemService(config);
        }

        public static SystemService create(LindormClientConfig config, String serviceName) throws LindormException {
            ServiceProvider provider = LindormServiceProvider.getServiceProvider(config);
            return provider.createSystemService(config, serviceName);
        }
    }

    public static class ExporterServiceProvider {
        public static ExporterService create(LindormClientConfig config) throws LindormException {
            ServiceProvider provider = LindormServiceProvider.getServiceProvider(config);
            return provider.createExporterService(config);
        }

        public static ExporterService create(LindormClientConfig config, String serviceName) throws LindormException {
            ServiceProvider provider = LindormServiceProvider.getServiceProvider(config);
            return provider.createExporterService(config, serviceName);
        }
    }

    public static class AdminServiceProvider {
        public static AdminService create(LindormClientConfig config) throws LindormException {
            ServiceProvider provider = LindormServiceProvider.getServiceProvider(config);
            return provider.createAdminService(config);
        }

        public static AdminService create(LindormClientConfig config, String serviceName) throws LindormException {
            ServiceProvider provider = LindormServiceProvider.getServiceProvider(config);
            return provider.createAdminService(config, serviceName);
        }
    }

    public static class FeedStreamServiceProvider {
        public static FeedStreamService create(LindormClientConfig config) throws LindormException {
            ServiceProvider provider = LindormServiceProvider.getServiceProvider(config);
            return provider.createFeedStreamService(config);
        }

        public static FeedStreamService create(LindormClientConfig config, String serviceName) throws LindormException {
            ServiceProvider provider = LindormServiceProvider.getServiceProvider(config);
            return provider.createFeedStreamService(config, serviceName);
        }
    }

    public static class WideColumnServiceProvider {
        public static WideColumnService create(LindormClientConfig config) throws LindormException {
            ServiceProvider provider = LindormServiceProvider.getServiceProvider(config);
            return provider.createWideColumnService(config);
        }

        public static WideColumnService create(LindormClientConfig config, String serviceName) throws LindormException {
            ServiceProvider provider = LindormServiceProvider.getServiceProvider(config);
            return provider.createWideColumnService(config, serviceName);
        }
    }

    public static class TableServiceProvider {
        public static TableService create(LindormClientConfig config) throws LindormException {
            ServiceProvider provider = LindormServiceProvider.getServiceProvider(config);
            return provider.createTableService(config);
        }

        public static TableService create(LindormClientConfig config, String serviceName) throws LindormException {
            ServiceProvider provider = LindormServiceProvider.getServiceProvider(config);
            return provider.createTableService(config, serviceName);
        }
    }
}

