/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.haclient.ClusterSwitchUtil;
import com.alibaba.hbase.haclient.ConnectInfo;
import com.alibaba.hbase.protobuf.generated.ClusterSwitchProto;
import com.google.protobuf.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.zookeeper.KeeperException;

public class ConnectInfoUtil {
    private static Log LOG = LogFactory.getLog(ConnectInfoUtil.class);
    public static final String CONNECTINFO_DIR = "hbase.haclient.connectinfo.dir";
    public static final String CONNECTINFO_DIR_DEFATULT = "/alihbase/connectinfo/";
    public static final String CONNECTINFO_FILE = "hbase.haclient.connectinfo.filename";
    public static final String CONNECTINFO_FILE_DEFAULT = "connectinfo.xml";
    public static final String WATCH_ZK_PREFIX = "hbase.haclient.watch.zk.";
    public static final String CONNECT_CONF_ACTIVE = "hbase.haclient.connect.active";
    public static final String CONNECT_CONF_STANDBY = "hbase.haclient.connect.standby";
    public static final String CONNECTINFO_ZK_CLUSTER = "hbase.connect.info.zk";
    public static final String LINK_RETRY_COUNT = "hbase.link.retry.count";

    private static void checkConnectInfo(List<String> watchZkList, String active, String standby, String zkClusterKey) throws IOException {
        if (watchZkList == null || watchZkList.isEmpty()) {
            throw new IOException("watch zk list is empty");
        }
        for (String zk : watchZkList) {
            if (ClusterSwitchUtil.isValidClusterKey(zk)) continue;
            throw new IOException("ZK " + zk + " in watch zk list is invaild");
        }
        if (!ClusterSwitchUtil.isValidConnectKey(active)) {
            throw new IOException("ConnnectConf:active " + active + " is invaild");
        }
        if (!ClusterSwitchUtil.isValidConnectKey(standby)) {
            throw new IOException("ConnnectConf:standby " + standby + " is invaild");
        }
        if (zkClusterKey != null && !ClusterSwitchUtil.isValidClusterKey(zkClusterKey)) {
            throw new IOException("ConnnectConf:zkClusterKey " + zkClusterKey + " is invaild");
        }
    }

    public static ConnectInfo toConnectInfo(byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        try {
            ProtobufUtil.expectPBMagicPrefix((byte[])data);
            int prefixLen = ProtobufUtil.lengthOfPBMagic();
            ClusterSwitchProto.ConnectInfo.Builder builder = ClusterSwitchProto.ConnectInfo.newBuilder();
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)prefixLen, (int)(data.length - prefixLen));
            ClusterSwitchProto.ConnectInfo connectInfo = builder.build();
            List<String> watchZkList = connectInfo.getWatchZkListList();
            ClusterSwitchProto.ConnectInfo.ConnectConf connectConf = connectInfo.getConnectConf();
            String active = null;
            String standby = null;
            if (null == connectConf) {
                throw new IOException("ConnectConf is null");
            }
            active = connectConf.getActive();
            standby = connectConf.getStandby();
            ConnectInfoUtil.checkConnectInfo(watchZkList, active, standby, null);
            return new ConnectInfo(watchZkList, active, standby);
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectInfo getConnectInfoFromZK(String endpoint, Configuration clientConf) throws IOException, KeeperException {
        Configuration conf = new Configuration();
        if (!ClusterSwitchUtil.isValidEndpoint(endpoint)) {
            throw new IOException("Endpoint " + endpoint + " has invalid format, vaild format is hostname:port");
        }
        conf.set("hbase.zookeeper.quorum", endpoint.split(":")[0]);
        conf.set("hbase.zookeeper.property.clientPort", endpoint.split(":")[1]);
        try (ZKWatcher zk = new ZKWatcher(conf, "GetCommand", null, false);){
            ConnectInfo connectInfo;
            String baseNode = ClusterSwitchUtil.getBaseNode(clientConf.get("haclient.base.node", "/haclient"), AliHBaseConstants.getHaClusterID(clientConf));
            if (ZKUtil.checkExists((ZKWatcher)zk, (String)baseNode) == -1) {
                throw new IOException("baseNode " + baseNode + " is not exist");
            }
            String connectNode = ZNodePaths.joinZNode((String)baseNode, (String)clientConf.get(ClusterSwitchUtil.ZOOKEEPER_CONNECT_NODE, ClusterSwitchUtil.ZOOKEEPER_CONNECT_NODE_DEFAULT));
            if (ZKUtil.checkExists((ZKWatcher)zk, (String)connectNode) == -1) {
                throw new IOException("connectNode " + connectNode + " is not exist");
            }
            byte[] data = ZKUtil.getDataNoWatch((ZKWatcher)zk, (String)connectNode, null);
            ConnectInfo connectInfo2 = connectInfo = ConnectInfoUtil.toConnectInfo(data);
            return connectInfo2;
        }
    }

    public static ConnectInfo getConnectInfoFromXML(Configuration conf) {
        return ConnectInfoUtil.getConnectInfoFromXML(System.getProperty("user.home") + conf.get(CONNECTINFO_DIR, CONNECTINFO_DIR_DEFATULT) + conf.get(CONNECTINFO_FILE, CONNECTINFO_FILE_DEFAULT));
    }

    public static ConnectInfo getConnectInfoFromXML(String file) {
        try {
            Configuration conf = new Configuration();
            conf.addResource(new Path(file));
            String active = conf.get(CONNECT_CONF_ACTIVE, null);
            String standby = conf.get(CONNECT_CONF_STANDBY, null);
            ArrayList<String> watchZkList = new ArrayList<String>();
            for (Map.Entry entry : conf) {
                if (!((String)entry.getKey()).startsWith(WATCH_ZK_PREFIX)) continue;
                watchZkList.add((String)entry.getValue());
            }
            String zkClusterKey = conf.get(CONNECTINFO_ZK_CLUSTER, null);
            ConnectInfoUtil.checkConnectInfo(watchZkList, active, standby, zkClusterKey);
            return new ConnectInfo(watchZkList, active, standby, zkClusterKey);
        }
        catch (Exception e) {
            LOG.error((Object)("Get connnect info from xml failed, " + e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushConnectInfo(ConnectInfo connectInfo, Configuration clientConf) {
        Configuration conf = new Configuration();
        conf.clear();
        List<String> zkWatchList = connectInfo.getWatchZkList();
        for (int i = 0; i < zkWatchList.size(); ++i) {
            conf.set(WATCH_ZK_PREFIX + (i + 1), zkWatchList.get(i));
        }
        conf.set(CONNECT_CONF_ACTIVE, connectInfo.getConnectConf().getActive());
        conf.set(CONNECT_CONF_STANDBY, connectInfo.getConnectConf().getStandby());
        if (connectInfo.getZkClusterKey() != null) {
            conf.set(CONNECTINFO_ZK_CLUSTER, connectInfo.getZkClusterKey());
        }
        String dirName = System.getProperty("user.home") + clientConf.get(CONNECTINFO_DIR, CONNECTINFO_DIR_DEFATULT);
        String fileName = dirName + clientConf.get(CONNECTINFO_FILE, CONNECTINFO_FILE_DEFAULT);
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream out = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            out = new FileOutputStream(file);
            conf.writeXml((OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            LOG.warn((Object)("flush connect info failed : " + e));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                LOG.debug((Object)"flushConnectInfo FileOutputStream close failed");
            }
        }
    }

    public static boolean isVaildTargetConnectKey(ConnectInfo connectInfo, String connectKey) {
        return connectInfo.getConnectConf().getActive().equals(connectKey.trim()) || connectInfo.getConnectConf().getStandby().equals(connectKey.trim());
    }

    public static byte[] toConnectInfoBytes(ConnectInfo connectInfo) {
        ClusterSwitchProto.ConnectInfo.Builder builder = ClusterSwitchProto.ConnectInfo.newBuilder();
        List<String> watchZkList = connectInfo.getWatchZkList();
        for (String zk : watchZkList) {
            builder.addWatchZkList(zk);
        }
        ClusterSwitchProto.ConnectInfo.ConnectConf.Builder connectConfBuilder = ClusterSwitchProto.ConnectInfo.ConnectConf.newBuilder();
        connectConfBuilder.setActive(connectInfo.getActiveConnectKey());
        connectConfBuilder.setStandby(connectInfo.getStandbyConnectKey());
        builder.setConnectConf(connectConfBuilder.build());
        return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
    }

    public static String getZkFromConnectInfo(ConnectInfo connectInfo, String clusterKey) {
        if (ClusterSwitchUtil.isValidClusterKey(clusterKey)) {
            return clusterKey;
        }
        List<String> watchZkList = connectInfo.getWatchZkList();
        if (clusterKey.equals(connectInfo.getActiveConnectKey())) {
            return watchZkList.get(0);
        }
        if (watchZkList.size() > 1) {
            return watchZkList.get(1);
        }
        return watchZkList.get(0);
    }

    public static String getClusterKeyFromConnectInfo(ConnectInfo connectInfo, String zkCluster) {
        List<String> watchZkList = connectInfo.getWatchZkList();
        if (watchZkList.size() > 1) {
            if (zkCluster.equals(watchZkList.get(0))) {
                return connectInfo.getActiveConnectKey();
            }
            if (zkCluster.equals(watchZkList.get(1))) {
                return connectInfo.getStandbyConnectKey();
            }
            LOG.info((Object)("ZkCluster " + zkCluster + " is not match zk in watch list, so return active cluster key"));
            return connectInfo.getActiveConnectKey();
        }
        return connectInfo.getActiveConnectKey();
    }

    public static Configuration getConfFromEndpoint(String endpoint, Configuration clientConf) {
        Configuration conf = new Configuration(clientConf);
        conf.set("hbase.zookeeper.quorum", endpoint.split(":")[0]);
        conf.set("hbase.zookeeper.property.clientPort", endpoint.split(":")[1]);
        return conf;
    }
}

