/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.google.common.base.Strings;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class AliHBaseConstants {
    public static final String USERNAME = "hbase.client.username";
    public static final String PASSWORD = "hbase.client.password";
    public static final String INSTANCEID = "hbase.client.instanceid";
    public static final String ALIHBASE_CLIENT_SCANNER_CACHING = "alihbase.client.scanner.caching";
    public static final int ALIHBASE_CLIENT_SCANNER_CACHING_DEFAULT = 100;
    public static final int ALIHBASE_CLIENT_SCANNER_CACHING_MAX = 1000;
    public static final String ALIHBASE_SERVER_NAME = "hbase.client.endpoint";
    public static final int DEFAULT_THRIFT_PORT = 9190;
    public static final int DEFAULT_SERVERLESS_PORT = 443;
    public static final int DEFAULT_RPC_SERVERLESS_PORT = 30022;
    public static final int DEFAULT_ALIHBASEUE_PORT = 30020;
    public static final String ALIHBASE_ACCESS_FROM_INTERNET = "hbase.access.from.internet";
    public static final boolean ALIHBASE_ACCESS_FROM_INTERNET_DEFAULT = false;
    public static final String ALIHBASE_USE_THRIFT = "hbase.client.use.thrift";
    public static final boolean ALIHBASE_USE_THRIFT_DEFAULT = false;
    public static final String SERVERLESS_IDENTIFIER = "hbase.serverless.identifier";
    public static final String DEFAULT_SERVERLESS_IDENTIFIER = "-hbase-serverless";
    public static final String HBASEUE_IDENTIFIER = "hbase.hbaseue.identifier";
    public static final String DEFAULT_HBASEUE_IDENTIFIER = "-proxy-hbaseue";
    public static final String HBASEUE_FACTORY_IMPL = "hbase.hbaseue.factory.impl";
    public static final String HBASE_CU_LIMIT = "hbase.client.cu.limit";
    public static final int DEFAULT_HBASEUE_CU_LIMIT = -1;
    public static final String HBASE_CU_IN_BYTES = "hbase.client.cu.in.bytes";
    public static final int DEFAULT_HBASE_CU_IN_BYTES = 4096;
    public static final String SOCKET_TIMEOUT_CONNECT = "hbase.ipc.client.socket.timeout.connect";
    public static final int DEFAULT_SOCKET_TIMEOUT_CONNECT = 10000;
    public static final String PUBLIC_HOSTNAME_IDENTIFIER = "hbase.public.hostname.identifier";
    public static final String DEFAULT_PUBLIC_HOSTNAME_IDENTIFIER = "-proxy-hbaseue-pub";
    public static final String LINDORM_PUBLIC_HOSTNAME_IDENTIFIER = "lindorm.public.hostname.identifier";
    public static final String DEFAULT_LINDORM_PUBLIC_HOSTNAME_IDENTIFIER = "-proxy-lindorm-pub";
    public static final String HBASE_MULTI_IDENTIFIER = "hbase.hbase.multi.identifier";
    public static final String DEFAULT_HBASE_MULTI_IDENTIFIER = "-proxy.bds.rds.aliyuncs.com";
    public static final String ENCODING_SETTING = "DATA_BLOCK_ENCODING";
    public static final String INDEX_ENCODING = "INDEX";
    public static final String COMPRESSION__SETTING = "COMPRESSION";
    public static final String ZSTD_COMPRESSION = "ZSTD";
    public static final String ALIHBASE_CLUSTER_TYPE = "hbase.cluster.type";
    public static final String HACLIENT_BASE_NODE = "haclient.base.node";
    public static final String HACLIENT_BASE_NODE_DEFAULT = "/haclient";
    public static final String HACLIENT_CLUSTER_ID = "hbase.hacluster.id";
    public static final String HACLIENT_CLUSTER_ID_DEFAULT = "haclient.cluster.id";
    public static final String OLD_HACLIENT_CLUSTER_ID = "haclient.cluster.id";
    public static final String STOP_FAKE_HBASE_CLIENT = "hbase.stopfake.hbaseclient";
    public static final String ALLOW_FULL_TALBE_SCAN = "ALLOW_FULL_TALBE_SCAN";
    public static final String MUTABILITY = "MUTABILITY";
    public static final String COLD_BOUNDARY = "CHS";
    public static final String CHS_L = "CHS_L";
    public static final int CHS_MAX_LAYER = 5;
    public static final String CHS_PROMOTE_ON_MAJOR = "CHS_PROMOTE_ON_MAJOR";
    public static final String HOT_ONLY = "HOT_ONLY";
    public static final String COLD_HOT_MERGE = "COLD_HOT_MERGE";
    public static final String HOT_FIRST = "COLD_HOT_MERGE";
    public static final String STORAGE_POLICY = "STORAGE_POLICY";
    public static final String STORAGETYPE_COLD = "COLD";
    public static final String STORAGETYPE_DEFAULT = "DEFAULT";
    public static final String DUALSERVICE_ENABLE = "hbase.dualservice.enable";
    public static final boolean DUALSERVICE_ENABLE_DEFAULT = false;
    public static final String DUALSERVICE_TABLE_ENABLE = "hbase.dualservice.table.enable";
    public static final boolean DEFAULT_DUALSERVICE_TABLE_ENABLE = false;
    public static final String DUALSERVICE_GLITCHTIMEOUT = "hbase.dualservice.glitchtimeout";
    public static final int DEFAULT_DUALSERVICE_GLITCHTIMEOUT = 30;
    public static final String DUALSERVICE_ACTIVE_EXECUTOR_THREAD = "hbase.dualservice.active.executor.thread";
    public static final int DEFAULT_DUALSERVICE_ACTIVE_EXECUTOR_THREAD = 100;
    public static final String DUALSERVICE_STANDBY_EXECUTOR_THREAD = "hbase.dualservice.standby.executor.thread";
    public static final int DEFAULT_DUALSERVICE_STANDBY_EXECUTOR_THREAD = 10;
    public static final String DUALSERVICE_ACTIVE_EXECUTOR_QUEUE = "hbase.dualservice.active.executor.queue";
    public static final int DEFAULT_DUALSERVICE_ACTIVE_EXECUTOR_QUEUE = 256;
    public static final String DUALSERVICE_STANDBY_EXECUTOR_QUEUE = "hbase.dualservice.standby.executor.queue";
    public static final int DEFAULT_DUALSERVICE_STANDBY_EXECUTOR_QUEUE = 256;
    public static final String DUALSERVICE_TRACE_ENABLE = "hbase.dualservice.trace.enable";
    public static final boolean DEFAULT_DUALSERVICE_TRACE_ENABLE = true;
    public static final String DUALSERVICE_TRACE_PERIOD = "hbase.dualservice.trace.period";
    public static final long DEFAULT_DUALSERVICE_TRACE_PERIOD = 300000L;
    public static final String AUTOSWITCH_ENABLE = "hbase.autoswitch.enable";
    public static final boolean DEFAULT_AUTOSWITCH_ENABLE = false;
    public static final String AUTOSWITCH_SWITCH_LEVEL = "hbase.autoswitch.switch.level";
    public static final String DEFAULT_AUTOSWITCH_SWITCH_LEVEL = "CONNECTION";
    public static final String CONNECTION_ACTIVE_FAIL_LIMIT = "connection.autoswitch.active.fail.limit";
    public static final int DEFAULT_CONNECTION_ACTIVE_FAIL_LIMIT = 50;
    public static final String CONNECTION_ACTIVE_FAIL_LIMIT_PECENTAGE = "connection.autoswitch.active.fail.limit.percentage";
    public static final float DEFAULT_CONNECTION_ACTIVE_FAIL_LIMIT_PECENTAGE = 0.1f;
    public static final String CONNECTION_STANDBY_SUCCESS_LIMIT = "connection.autoswitch.standby.success.limit";
    public static final int DEFAULT_CONNECTION_STANDBY_SUCCESS_LIMIT = 5;
    public static final String TABLE_ACTIVE_FAIL_LIMIT = "table.autoswitch.active.fail.limit";
    public static final int DEFAULT_TABLE_ACTIVE_FAIL_LIMIT = 25;
    public static final String TABLE_ACTIVE_FAIL_LIMIT_PECENTAGE = "table.autoswitch.active.fail.limit.percentage";
    public static final float DEFAULT_TABLE_ACTIVE_FAIL_LIMIT_PECENTAGE = 0.1f;
    public static final String TABLE_STANDBY_SUCCESS_LIMIT = "table.autoswitch.standby.success.limit";
    public static final int DEFAULT_TABLE_STANDBY_SUCCESS_LIMIT = 3;
    public static final String KEY_ACTIVE_FAIL_LIMIT = "key.autoswitch.active.fail.limit";
    public static final int DEFAULT_KEY_ACTIVE_FAIL_LIMIT = 10;
    public static final String KEY_STANDBY_SUCCESS_LIMIT = "key.autoswitch.standby.success.limit";
    public static final int DEFAULT_KEY_STANDBY_SUCCESS_LIMIT = 1;
    public static final String AUTOSWITCH_INTERVAL = "autoswitch.interval";
    public static final long DEFAULT_AUTOSWITCH_INTERVAL = Long.MAX_VALUE;
    public static final String IN_PHOENIX_ON_LINDORM = "hbase.hbaseue.phoenix.enabled";
    public static final boolean DEFAULT_IN_PHOENIX_ON_LINDORM = false;
    public static final String START_TS_HEADER = "startTs";
    public static final String FAILMARKER = "failed";
    public static final String ClUSTER_SWITCH_COMMAND_WAITTIME = "hbase.cluster.switcher.command.waittime";
    public static final int DEFAULT_ClUSTER_SWITCH_COMMAND_WAITTIME = 200;
    public static final String ClUSTER_SWITCH_POOL_SIZE = "hbase.cluster.switcher.pool.size";
    public static final String ClUSTER_SWITCH_SHUTDOWN_WAIT = "hbase.cluster.switcher.shutdown.wait";
    public static final String TABLE_ATTRIBUTES_KEY = "LINDORM_TABLE_ATTRS";
    public static final byte[] TABLE_ATTRIBUTES_KEY_BYTES = Bytes.toBytes("LINDORM_TABLE_ATTRS");
    public static final String INDEX_NAMES_KEY = "LINDORM_INDEX_NAME_ATTRS";
    public static final byte[] INDEX_NAMES_KEY_BYTES = Bytes.toBytes("LINDORM_INDEX_NAME_ATTRS");
    public static final String INDEX_ID_KEY = "LINDORM_INDEX_ID_ATTRS";
    public static final byte[] INDEX_ID_KEY_BYTES = Bytes.toBytes("LINDORM_INDEX_ID_ATTRS");
    public static final String SILENCE_INDEXES_KEY = "LINDORM_SILENCE_INDEXES_ATTRS";
    public static final byte[] SILENCE_INDEXES_KEY_BYTES = Bytes.toBytes("LINDORM_SILENCE_INDEXES_ATTRS");
    public static final String FAMILY_ATTRIBUTES_KEY = "LINDORM_FAMILY_ATTRS";
    public static final byte[] FAMILY_ATTRIBUTES_KEY_BYTES = Bytes.toBytes("LINDORM_FAMILY_ATTRS");
    public static final String PK_ATTRIBUTES_KEY = "LINDORM_PK_ATTRS";
    public static final byte[] PK_ATTRIBUTES_KEY_BYTES = Bytes.toBytes("LINDORM_PK_ATTRS");
    public static final String NONPK_ATTRIBUTES_KEY = "LINDORM_NONPK_ATTRS";
    public static final byte[] NONPK_ATTRIBUTES_KEY_BYTES = Bytes.toBytes("LINDORM_NONPK_ATTRS");
    public static final String TABLESERVICE_ATTRIBUTES_KEY = "TABLESERVICE_ATTRS";
    public static final byte[] TABLESERVICE_ATTRIBUTES_KEY_BYTES = Bytes.toBytes("TABLESERVICE_ATTRS");

    public static boolean isHBaseUEConnectionString(Configuration conf, String hostStr) {
        String hbaseueIdentifier = conf.get(HBASEUE_IDENTIFIER, DEFAULT_HBASEUE_IDENTIFIER);
        String serverlessIdentifier = conf.get(SERVERLESS_IDENTIFIER, DEFAULT_SERVERLESS_IDENTIFIER);
        if (Strings.isNullOrEmpty((String)hostStr)) {
            return false;
        }
        if (hostStr.contains(hbaseueIdentifier) || hostStr.contains(serverlessIdentifier)) {
            return true;
        }
        if (hostStr.contains(":")) {
            try {
                int port;
                String[] parts = hostStr.split(":");
                if (parts.length > 0 && ((port = Integer.valueOf(parts[parts.length - 1]).intValue()) == 30020 || port == 9190 || port == 443 || port == 30022)) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isHBaseMultiConnectionString(Configuration conf, String hostStr) {
        String hbaseMultiIdentifier = conf.get(HBASE_MULTI_IDENTIFIER, DEFAULT_HBASE_MULTI_IDENTIFIER);
        if (Strings.isNullOrEmpty((String)hostStr)) {
            return false;
        }
        return hostStr.contains(hbaseMultiIdentifier);
    }

    public static String getHaClusterID(Configuration conf) {
        String haClusterID = conf.get(HACLIENT_CLUSTER_ID);
        if (StringUtils.isBlank((String)haClusterID)) {
            haClusterID = conf.get("haclient.cluster.id");
        }
        return haClusterID;
    }

    public static enum ClusterType {
        HBASE("HBASE"),
        HBASEUE("HBASEUE");

        private final String value;

        private ClusterType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

