/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.config;

import com.alibaba.fescar.common.exception.NotSupportYetException;
import com.alibaba.fescar.config.AbstractConfiguration;
import com.alibaba.fescar.config.ApolloConfiguration;
import com.alibaba.fescar.config.ConfigType;
import com.alibaba.fescar.config.Configuration;
import com.alibaba.fescar.config.FileConfiguration;
import com.alibaba.fescar.config.NacosConfiguration;
import com.alibaba.fescar.config.ZKConfiguration;
import com.alibaba.nacos.api.exception.NacosException;
import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFactory.class);
    private static final String REGISTRY_CONF = "registry.conf";
    public static final Configuration FILE_INSTANCE = new FileConfiguration("registry.conf");
    private static final String NAME_KEY = "name";
    private static final String FILE_TYPE = "file";

    public static Configuration getInstance() {
        AbstractConfiguration configuration;
        ConfigType configType = null;
        String configTypeName = null;
        try {
            configTypeName = FILE_INSTANCE.getConfig("config.type");
            configType = ConfigType.getType(configTypeName);
        }
        catch (Exception exx) {
            throw new NotSupportYetException("not support register type: " + configTypeName);
        }
        switch (configType) {
            case Nacos: {
                try {
                    configuration = new NacosConfiguration();
                    break;
                }
                catch (NacosException e) {
                    throw new RuntimeException(e);
                }
            }
            case Apollo: {
                try {
                    configuration = ApolloConfiguration.getInstance();
                    break;
                }
                catch (ApolloConfigException e) {
                    throw new RuntimeException(e);
                }
            }
            case File: {
                String pathDataId = "config.file.name";
                String name = FILE_INSTANCE.getConfig(pathDataId);
                configuration = new FileConfiguration(name);
                break;
            }
            case ZK: {
                try {
                    configuration = new ZKConfiguration();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new NotSupportYetException("not support register type:" + (Object)((Object)configType));
            }
        }
        return configuration;
    }
}

