package com.alibaba.tmq.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;

/**
 * 正则表达式相关工具
 * @author tianyao.myc
 *
 */
public class RegularExpressionUtil implements Constants {

	/**
	 * 正则匹配
	 *  expression
	 *  content
	 *
	 */
	public static boolean match(String expression, String content) {

		if(WILDCARD.equals(expression)) {
			return true;
		}
		
		if(StringUtil.isBlank(expression) && StringUtil.isBlank(content)) {
			return true;
		}
		
		if(StringUtil.isBlank(expression) || StringUtil.isBlank(content)) {
			return false;
		}
		
		Pattern pattern = Pattern.compile(expression);
		
		Matcher matcher = pattern.matcher(content);
		
		return matcher.matches();
	}
	
	/**
	 * 判断是否正确命名
	 * 英文字符和 - _ . 数字等字符 
	 *  name
	 *
	 */
	public static boolean correctName(String name) {
		
		if(null == name || name.isEmpty()) {
			return false;
		}
		
		if(name.contains("@") || name.contains("#")) {
			return false;
		}
		
		return name.matches("[\\w-\\.]+");
	}
	
}
