package com.alibaba.tmq.common.util;

import java.util.Date;

import com.alibaba.tmq.common.constants.Constants;

/**
 * 路径相关工具
 * @author tianyao.myc
 *
 */
public class PathUtil implements Constants {

	public static String getH2Path() {
		String separator = System.getProperty(FILE_SEPARATOR);
		return System.getProperties().getProperty(USER_HOME) + separator +  ".h2" + separator;
	}

	public static String getLoggerPath() {
		String separator = System.getProperty(FILE_SEPARATOR);
		return System.getProperties().getProperty(USER_HOME) + separator + "logs";
	}
	
	/**
	 * 获取用户home目录配置文件路径
	 *  fileName
	 *
	 */
	public static String getHomeConfigPath(String fileName) {
		String separator = System.getProperty(FILE_SEPARATOR);
		return System.getProperties().getProperty(USER_HOME) + separator + TMQ_CONFIG + separator + fileName;
	}
	
	/**
	 * 获取Master新区路径
	 * 比如/home/admin/tmq-data/master-data/new-region/
	 *
	 */
	public static String getMasterNewRegionPath() {
		return HOME_PATH + SEPARATOR + TMQ_DATA + SEPARATOR + TMQ_MASTER_DATA + SEPARATOR + TMQ_NEW_REGION + SEPARATOR;
	}
	
	/**
	 * 获取Master新区文件
	 * 比如/home/admin/tmq-data/master-data/new-region/fileName.tmq
	 *  fileName
	 *
	 */
	public static String getMasterNewRegionFilePath(String fileName) {
		return HOME_PATH + SEPARATOR + TMQ_DATA + SEPARATOR + TMQ_MASTER_DATA + SEPARATOR + TMQ_NEW_REGION + SEPARATOR + fileName + TMQ_DATA_EXT;
	}
	
	/**
	 * 获取Master活跃区路径
	 * 比如/home/admin/tmq-data/master-data/active-region/
	 *
	 */
	public static String getMasterActiveRegionPath() {
		return HOME_PATH + SEPARATOR + TMQ_DATA + SEPARATOR + TMQ_MASTER_DATA + SEPARATOR + TMQ_ACTIVE_REGION + SEPARATOR;
	}
	
	/**
	 * 获取Master活跃区文件
	 * 比如/home/admin/tmq-data/master-data/active-region/fileName.tmq
	 *  fileName
	 *
	 */
	public static String getMasterActiveRegionFilePath(String fileName) {
		return HOME_PATH + SEPARATOR + TMQ_DATA + SEPARATOR + TMQ_MASTER_DATA + SEPARATOR + TMQ_ACTIVE_REGION + SEPARATOR + fileName + TMQ_DATA_EXT;
	}
	
	/**
	 * 获取Master老区路径
	 * 比如/home/admin/tmq-data/master-data/old-region/
	 *
	 */
	public static String getMasterOldRegionPath() {
		return HOME_PATH + SEPARATOR + TMQ_DATA + SEPARATOR + TMQ_MASTER_DATA + SEPARATOR + TMQ_OLD_REGION + SEPARATOR;
	}
	
	/**
	 * 获取Master老区文件
	 * 比如/home/admin/tmq-data/master-data/old-region/fileName.tmq
	 *  fileName
	 *
	 */
	public static String getMasterOldRegionFilePath(String fileName) {
		return HOME_PATH + SEPARATOR + TMQ_DATA + SEPARATOR + TMQ_MASTER_DATA + SEPARATOR + TMQ_OLD_REGION + SEPARATOR + fileName + TMQ_DATA_EXT;
	}
	
	/**
	 * 获取Master压缩区路径
	 * 比如/home/admin/tmq-data/master-data/compression-region/
	 *
	 */
	public static String getMasterCompressionRegionPath() {
		return HOME_PATH + SEPARATOR + TMQ_DATA + SEPARATOR + TMQ_MASTER_DATA + SEPARATOR + TMQ_COMPRESSION_REGION + SEPARATOR;
	}
	
	/**
	 * 获取Master压缩区文件
	 * 比如/home/admin/tmq-data/master-data/compression-region/fileName.tmq
	 *  fileName
	 *
	 */
	public static String getMasterCompressionRegionFilePath(String fileName) {
		return HOME_PATH + SEPARATOR + TMQ_DATA + SEPARATOR + TMQ_MASTER_DATA + SEPARATOR + TMQ_COMPRESSION_REGION + SEPARATOR + fileName + TMQ_DATA_EXT;
	}
	
	/**
	 * 获取桶路径
	 *  bucket
	 *
	 */
	public static String getMasterCompressionRegionBucketPath(String bucket) {
		return getMasterCompressionRegionPath() + bucket;
	}
	
	public static int HOUR_MIN = 2;
	public static int HOUR_MAX = 24;
	
	/**
	 * 压缩小时分级目录
	 *  hour
	 *
	 */
	public static String getCompressionHourLevelPath(int hour) {
		
		if(hour < HOUR_MIN || hour > HOUR_MAX) {
			return null;
		}
		
		return getMasterCompressionRegionPath() + TMQ_LEVEL_HOUR + hour;
	}
	
	public static int DAY_MIN = 2;
	public static int DAY_MAX = 31;
	
	/**
	 * 压缩天分级目录
	 *  day
	 *
	 */
	public static String getCompressionDayLevelPath(int day) {
		
		if(day < DAY_MIN || day > DAY_MAX) {
			return null;
		}
		
		return getMasterCompressionRegionPath() + TMQ_LEVEL_DAY + day;
	}
	
	public static int MONTH_MIN = 2;
	public static int MONTH_MAX = 12;
	
	/**
	 * 压缩月分级目录
	 *  month
	 *
	 */
	public static String getCompressionMonthLevelPath(int month) {
		
		if(month < MONTH_MIN || month > MONTH_MAX) {
			return null;
		}
		
		return getMasterCompressionRegionPath() + TMQ_LEVEL_MONTH + month;
	}
	
	public static int YEAR_MIN = 2;
	public static int YEAR_MAX = 3;
	
	/**
	 * 压缩年分级目录
	 *  year
	 *
	 */
	public static String getCompressionYearLevelPath(int year) {
		
		if(year < YEAR_MIN || year > YEAR_MAX) {
			return null;
		}
		
		return getMasterCompressionRegionPath() + TMQ_LEVEL_YEAR + year;
	}
	
	/**
	 * 获取目标分级目录
	 *  timePeriod
	 *
	 */
	public static String getCompressionTargetLevelPath(String timePeriod) {
		
		Date date = TimeUtil.string2Date(timePeriod, TIME_FORMAT_CHART);
		
		int year 	= date.getYear();
		int month 	= date.getMonth();
		int day 	= date.getDay();
		
		int hours 	= date.getHours();
		int minutes = date.getMinutes();
		
		Date dateNow = new Date();
		
		int yearNow 	= dateNow.getYear();
		int monthNow 	= dateNow.getMonth();
		int dayNow 		= dateNow.getDay();
		
		int hoursNow 	= dateNow.getHours();
		int minutesNow 	= dateNow.getMinutes();
		
		if(year - yearNow > 0) {
			return getCompressionYearLevelPath(year - yearNow);
		}
		
		if(month - monthNow > 0) {
			return getCompressionMonthLevelPath(month - monthNow);
		}
		
		if(day - dayNow > 0) {
			return getCompressionDayLevelPath(day - dayNow);
		}
		
		if(hours - hoursNow > 0) {
			return getCompressionHourLevelPath(hours - hoursNow);
		}
		
		return null;
	}
	
	/**
	 * 获取服务器集群路径
	 * 列如/zk-tmq-root/server-cluster/1
	 *
	 */
	public static String getServerClusterPath(long serverClusterId) {
		return FORWARD_SLASH + DEFAULT_ZK_ROOT_PATH + FORWARD_SLASH + ZK_SERVER_CLUSTER + FORWARD_SLASH + serverClusterId;
	}
	
	/**
	 * 获取服务器节点路径
	 * 列如/zk-tmq-root/server-cluster/1/10.232.10.184:22015
	 *  serverClusterId
	 *  server
	 *
	 */
	public static String getServerPath(long serverClusterId, String server) {
		return FORWARD_SLASH + DEFAULT_ZK_ROOT_PATH + FORWARD_SLASH + ZK_SERVER_CLUSTER + FORWARD_SLASH + serverClusterId + FORWARD_SLASH + server;
	}
	
	/**
	 * 获取控制台web服务器列表路径
	 * 列如/zk-tmq-root/console-cluster
	 *
	 */
	public static String getConsolePath() {
		return FORWARD_SLASH + DEFAULT_ZK_ROOT_PATH + FORWARD_SLASH + ZK_CONSOLE_CLUSTER;
	}
	
	/**
	 * 获取控制台web服务器路径
	 * 列如/zk-tmq-root/console-cluster/10.232.10.184
	 *  server
	 *
	 */
	public static String getConsoleServerPath(String server) {
		return FORWARD_SLASH + DEFAULT_ZK_ROOT_PATH + FORWARD_SLASH + ZK_CONSOLE_CLUSTER + FORWARD_SLASH + server;
	}
}
