package com.alibaba.tmq.common.util;

import java.io.File;

/**
 * 磁盘相关工具
 * @author tianyao.myc
 *
 */
public class DiskUtil {

	/**
	 * 获取分区大小
	 *  path
	 *
	 */
	public static long acquirePartitionTotalSize(final String path) {
		
		if(null == path || path.isEmpty()) {
			return -1L;
		}
		
		File file = new File(path);
		if(! file.exists()) {
			boolean result = file.mkdirs();
			if(! result) {
				return -1L;
			}
		}
		
		return file.getTotalSpace();
	}
	
	/**
	 * 获取分区空闲大小
	 *  path
	 *
	 */
	public static long acquirePartitionFreeSize(final String path) {
		
		if(null == path || path.isEmpty()) {
			return -1L;
		}
		
		File file = new File(path);
		if(! file.exists()) {
			boolean result = file.mkdirs();
			if(! result) {
				return -1L;
			}
		}
		
		return file.getFreeSpace();
	}
	
	/**
	 * 已使用的空间大小
	 *  path
	 *
	 */
	public static long acquirePartitionUsedSize(final String path) {
		return acquirePartitionTotalSize(path) - acquirePartitionFreeSize(path);
	}
	
}
